/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableMessage is an enum
type OpcuaNodeIdServicesVariableMessage int32

type IOpcuaNodeIdServicesVariableMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableMessage_MessageSecurityMode_EnumStrings OpcuaNodeIdServicesVariableMessage = 7595
)

var OpcuaNodeIdServicesVariableMessageValues []OpcuaNodeIdServicesVariableMessage

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableMessageValues = []OpcuaNodeIdServicesVariableMessage{
		OpcuaNodeIdServicesVariableMessage_MessageSecurityMode_EnumStrings,
	}
}

func OpcuaNodeIdServicesVariableMessageByValue(value int32) (enum OpcuaNodeIdServicesVariableMessage, ok bool) {
	switch value {
	case 7595:
		return OpcuaNodeIdServicesVariableMessage_MessageSecurityMode_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableMessageByName(value string) (enum OpcuaNodeIdServicesVariableMessage, ok bool) {
	switch value {
	case "MessageSecurityMode_EnumStrings":
		return OpcuaNodeIdServicesVariableMessage_MessageSecurityMode_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableMessageKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableMessageValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableMessage(structType any) OpcuaNodeIdServicesVariableMessage {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableMessage {
		if sOpcuaNodeIdServicesVariableMessage, ok := typ.(OpcuaNodeIdServicesVariableMessage); ok {
			return sOpcuaNodeIdServicesVariableMessage
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableMessage) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableMessageParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableMessage, error) {
	return OpcuaNodeIdServicesVariableMessageParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableMessageParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableMessage, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableMessage", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableMessage")
	}
	if enum, ok := OpcuaNodeIdServicesVariableMessageByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableMessage")
		return OpcuaNodeIdServicesVariableMessage(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableMessage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableMessage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableMessage", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableMessage) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableMessage) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableMessage_MessageSecurityMode_EnumStrings:
		return "MessageSecurityMode_EnumStrings"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableMessage) String() string {
	return e.PLC4XEnumName()
}
