/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// XmlElement is the corresponding interface of XmlElement
type XmlElement interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetLength returns Length (property field)
	GetLength() int32
	// GetValue returns Value (property field)
	GetValue() []string
	// IsXmlElement is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsXmlElement()
	// CreateBuilder creates a XmlElementBuilder
	CreateXmlElementBuilder() XmlElementBuilder
}

// _XmlElement is the data-structure of this message
type _XmlElement struct {
	Length int32
	Value  []string
}

var _ XmlElement = (*_XmlElement)(nil)

// NewXmlElement factory function for _XmlElement
func NewXmlElement(length int32, value []string) *_XmlElement {
	return &_XmlElement{Length: length, Value: value}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// XmlElementBuilder is a builder for XmlElement
type XmlElementBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(length int32, value []string) XmlElementBuilder
	// WithLength adds Length (property field)
	WithLength(int32) XmlElementBuilder
	// WithValue adds Value (property field)
	WithValue(...string) XmlElementBuilder
	// Build builds the XmlElement or returns an error if something is wrong
	Build() (XmlElement, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() XmlElement
}

// NewXmlElementBuilder() creates a XmlElementBuilder
func NewXmlElementBuilder() XmlElementBuilder {
	return &_XmlElementBuilder{_XmlElement: new(_XmlElement)}
}

type _XmlElementBuilder struct {
	*_XmlElement

	collectedErr []error
}

var _ (XmlElementBuilder) = (*_XmlElementBuilder)(nil)

func (b *_XmlElementBuilder) WithMandatoryFields(length int32, value []string) XmlElementBuilder {
	return b.WithLength(length).WithValue(value...)
}

func (b *_XmlElementBuilder) WithLength(length int32) XmlElementBuilder {
	b.Length = length
	return b
}

func (b *_XmlElementBuilder) WithValue(value ...string) XmlElementBuilder {
	b.Value = value
	return b
}

func (b *_XmlElementBuilder) Build() (XmlElement, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._XmlElement.deepCopy(), nil
}

func (b *_XmlElementBuilder) MustBuild() XmlElement {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_XmlElementBuilder) DeepCopy() any {
	_copy := b.CreateXmlElementBuilder().(*_XmlElementBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateXmlElementBuilder creates a XmlElementBuilder
func (b *_XmlElement) CreateXmlElementBuilder() XmlElementBuilder {
	if b == nil {
		return NewXmlElementBuilder()
	}
	return &_XmlElementBuilder{_XmlElement: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_XmlElement) GetLength() int32 {
	return m.Length
}

func (m *_XmlElement) GetValue() []string {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastXmlElement(structType any) XmlElement {
	if casted, ok := structType.(XmlElement); ok {
		return casted
	}
	if casted, ok := structType.(*XmlElement); ok {
		return *casted
	}
	return nil
}

func (m *_XmlElement) GetTypeName() string {
	return "XmlElement"
}

func (m *_XmlElement) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (length)
	lengthInBits += 32

	// Array field
	if len(m.Value) > 0 {
		lengthInBits += 8 * uint16(len(m.Value))
	}

	return lengthInBits
}

func (m *_XmlElement) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func XmlElementParse(ctx context.Context, theBytes []byte) (XmlElement, error) {
	return XmlElementParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func XmlElementParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (XmlElement, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (XmlElement, error) {
		return XmlElementParseWithBuffer(ctx, readBuffer)
	}
}

func XmlElementParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (XmlElement, error) {
	v, err := (&_XmlElement{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_XmlElement) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__xmlElement XmlElement, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("XmlElement"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for XmlElement")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	length, err := ReadSimpleField(ctx, "length", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'length' field"))
	}
	m.Length = length

	value, err := ReadCountArrayField[string](ctx, "value", ReadString(readBuffer, uint32(8)), uint64(length))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("XmlElement"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for XmlElement")
	}

	return m, nil
}

func (m *_XmlElement) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_XmlElement) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("XmlElement"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for XmlElement")
	}

	if err := WriteSimpleField[int32](ctx, "length", m.GetLength(), WriteSignedInt(writeBuffer, 32)); err != nil {
		return errors.Wrap(err, "Error serializing 'length' field")
	}

	if err := WriteSimpleTypeArrayField(ctx, "value", m.GetValue(), WriteString(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("XmlElement"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for XmlElement")
	}
	return nil
}

func (m *_XmlElement) IsXmlElement() {}

func (m *_XmlElement) DeepCopy() any {
	return m.deepCopy()
}

func (m *_XmlElement) deepCopy() *_XmlElement {
	if m == nil {
		return nil
	}
	_XmlElementCopy := &_XmlElement{
		m.Length,
		utils.DeepCopySlice[string, string](m.Value),
	}
	return _XmlElementCopy
}

func (m *_XmlElement) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
