/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AlarmMessageAckPushType is the corresponding interface of AlarmMessageAckPushType
type AlarmMessageAckPushType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetTimeStamp returns TimeStamp (property field)
	GetTimeStamp() DateAndTime
	// GetFunctionId returns FunctionId (property field)
	GetFunctionId() uint8
	// GetNumberOfObjects returns NumberOfObjects (property field)
	GetNumberOfObjects() uint8
	// GetMessageObjects returns MessageObjects (property field)
	GetMessageObjects() []AlarmMessageAckObjectPushType
	// IsAlarmMessageAckPushType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAlarmMessageAckPushType()
	// CreateBuilder creates a AlarmMessageAckPushTypeBuilder
	CreateAlarmMessageAckPushTypeBuilder() AlarmMessageAckPushTypeBuilder
}

// _AlarmMessageAckPushType is the data-structure of this message
type _AlarmMessageAckPushType struct {
	TimeStamp       DateAndTime
	FunctionId      uint8
	NumberOfObjects uint8
	MessageObjects  []AlarmMessageAckObjectPushType
}

var _ AlarmMessageAckPushType = (*_AlarmMessageAckPushType)(nil)

// NewAlarmMessageAckPushType factory function for _AlarmMessageAckPushType
func NewAlarmMessageAckPushType(timeStamp DateAndTime, functionId uint8, numberOfObjects uint8, messageObjects []AlarmMessageAckObjectPushType) *_AlarmMessageAckPushType {
	if timeStamp == nil {
		panic("timeStamp of type DateAndTime for AlarmMessageAckPushType must not be nil")
	}
	return &_AlarmMessageAckPushType{TimeStamp: timeStamp, FunctionId: functionId, NumberOfObjects: numberOfObjects, MessageObjects: messageObjects}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AlarmMessageAckPushTypeBuilder is a builder for AlarmMessageAckPushType
type AlarmMessageAckPushTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(timeStamp DateAndTime, functionId uint8, numberOfObjects uint8, messageObjects []AlarmMessageAckObjectPushType) AlarmMessageAckPushTypeBuilder
	// WithTimeStamp adds TimeStamp (property field)
	WithTimeStamp(DateAndTime) AlarmMessageAckPushTypeBuilder
	// WithTimeStampBuilder adds TimeStamp (property field) which is build by the builder
	WithTimeStampBuilder(func(DateAndTimeBuilder) DateAndTimeBuilder) AlarmMessageAckPushTypeBuilder
	// WithFunctionId adds FunctionId (property field)
	WithFunctionId(uint8) AlarmMessageAckPushTypeBuilder
	// WithNumberOfObjects adds NumberOfObjects (property field)
	WithNumberOfObjects(uint8) AlarmMessageAckPushTypeBuilder
	// WithMessageObjects adds MessageObjects (property field)
	WithMessageObjects(...AlarmMessageAckObjectPushType) AlarmMessageAckPushTypeBuilder
	// Build builds the AlarmMessageAckPushType or returns an error if something is wrong
	Build() (AlarmMessageAckPushType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AlarmMessageAckPushType
}

// NewAlarmMessageAckPushTypeBuilder() creates a AlarmMessageAckPushTypeBuilder
func NewAlarmMessageAckPushTypeBuilder() AlarmMessageAckPushTypeBuilder {
	return &_AlarmMessageAckPushTypeBuilder{_AlarmMessageAckPushType: new(_AlarmMessageAckPushType)}
}

type _AlarmMessageAckPushTypeBuilder struct {
	*_AlarmMessageAckPushType

	collectedErr []error
}

var _ (AlarmMessageAckPushTypeBuilder) = (*_AlarmMessageAckPushTypeBuilder)(nil)

func (b *_AlarmMessageAckPushTypeBuilder) WithMandatoryFields(timeStamp DateAndTime, functionId uint8, numberOfObjects uint8, messageObjects []AlarmMessageAckObjectPushType) AlarmMessageAckPushTypeBuilder {
	return b.WithTimeStamp(timeStamp).WithFunctionId(functionId).WithNumberOfObjects(numberOfObjects).WithMessageObjects(messageObjects...)
}

func (b *_AlarmMessageAckPushTypeBuilder) WithTimeStamp(timeStamp DateAndTime) AlarmMessageAckPushTypeBuilder {
	b.TimeStamp = timeStamp
	return b
}

func (b *_AlarmMessageAckPushTypeBuilder) WithTimeStampBuilder(builderSupplier func(DateAndTimeBuilder) DateAndTimeBuilder) AlarmMessageAckPushTypeBuilder {
	builder := builderSupplier(b.TimeStamp.CreateDateAndTimeBuilder())
	var err error
	b.TimeStamp, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "DateAndTimeBuilder failed"))
	}
	return b
}

func (b *_AlarmMessageAckPushTypeBuilder) WithFunctionId(functionId uint8) AlarmMessageAckPushTypeBuilder {
	b.FunctionId = functionId
	return b
}

func (b *_AlarmMessageAckPushTypeBuilder) WithNumberOfObjects(numberOfObjects uint8) AlarmMessageAckPushTypeBuilder {
	b.NumberOfObjects = numberOfObjects
	return b
}

func (b *_AlarmMessageAckPushTypeBuilder) WithMessageObjects(messageObjects ...AlarmMessageAckObjectPushType) AlarmMessageAckPushTypeBuilder {
	b.MessageObjects = messageObjects
	return b
}

func (b *_AlarmMessageAckPushTypeBuilder) Build() (AlarmMessageAckPushType, error) {
	if b.TimeStamp == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'timeStamp' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._AlarmMessageAckPushType.deepCopy(), nil
}

func (b *_AlarmMessageAckPushTypeBuilder) MustBuild() AlarmMessageAckPushType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AlarmMessageAckPushTypeBuilder) DeepCopy() any {
	_copy := b.CreateAlarmMessageAckPushTypeBuilder().(*_AlarmMessageAckPushTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateAlarmMessageAckPushTypeBuilder creates a AlarmMessageAckPushTypeBuilder
func (b *_AlarmMessageAckPushType) CreateAlarmMessageAckPushTypeBuilder() AlarmMessageAckPushTypeBuilder {
	if b == nil {
		return NewAlarmMessageAckPushTypeBuilder()
	}
	return &_AlarmMessageAckPushTypeBuilder{_AlarmMessageAckPushType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AlarmMessageAckPushType) GetTimeStamp() DateAndTime {
	return m.TimeStamp
}

func (m *_AlarmMessageAckPushType) GetFunctionId() uint8 {
	return m.FunctionId
}

func (m *_AlarmMessageAckPushType) GetNumberOfObjects() uint8 {
	return m.NumberOfObjects
}

func (m *_AlarmMessageAckPushType) GetMessageObjects() []AlarmMessageAckObjectPushType {
	return m.MessageObjects
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAlarmMessageAckPushType(structType any) AlarmMessageAckPushType {
	if casted, ok := structType.(AlarmMessageAckPushType); ok {
		return casted
	}
	if casted, ok := structType.(*AlarmMessageAckPushType); ok {
		return *casted
	}
	return nil
}

func (m *_AlarmMessageAckPushType) GetTypeName() string {
	return "AlarmMessageAckPushType"
}

func (m *_AlarmMessageAckPushType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (timeStamp)
	lengthInBits += m.TimeStamp.GetLengthInBits(ctx)

	// Simple field (functionId)
	lengthInBits += 8

	// Simple field (numberOfObjects)
	lengthInBits += 8

	// Array field
	if len(m.MessageObjects) > 0 {
		for _curItem, element := range m.MessageObjects {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.MessageObjects), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_AlarmMessageAckPushType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AlarmMessageAckPushTypeParse(ctx context.Context, theBytes []byte) (AlarmMessageAckPushType, error) {
	return AlarmMessageAckPushTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func AlarmMessageAckPushTypeParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (AlarmMessageAckPushType, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (AlarmMessageAckPushType, error) {
		return AlarmMessageAckPushTypeParseWithBuffer(ctx, readBuffer)
	}
}

func AlarmMessageAckPushTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AlarmMessageAckPushType, error) {
	v, err := (&_AlarmMessageAckPushType{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_AlarmMessageAckPushType) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__alarmMessageAckPushType AlarmMessageAckPushType, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AlarmMessageAckPushType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AlarmMessageAckPushType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	timeStamp, err := ReadSimpleField[DateAndTime](ctx, "timeStamp", ReadComplex[DateAndTime](DateAndTimeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timeStamp' field"))
	}
	m.TimeStamp = timeStamp

	functionId, err := ReadSimpleField(ctx, "functionId", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'functionId' field"))
	}
	m.FunctionId = functionId

	numberOfObjects, err := ReadSimpleField(ctx, "numberOfObjects", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberOfObjects' field"))
	}
	m.NumberOfObjects = numberOfObjects

	messageObjects, err := ReadCountArrayField[AlarmMessageAckObjectPushType](ctx, "messageObjects", ReadComplex[AlarmMessageAckObjectPushType](AlarmMessageAckObjectPushTypeParseWithBuffer, readBuffer), uint64(numberOfObjects))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageObjects' field"))
	}
	m.MessageObjects = messageObjects

	if closeErr := readBuffer.CloseContext("AlarmMessageAckPushType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AlarmMessageAckPushType")
	}

	return m, nil
}

func (m *_AlarmMessageAckPushType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AlarmMessageAckPushType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("AlarmMessageAckPushType"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for AlarmMessageAckPushType")
	}

	if err := WriteSimpleField[DateAndTime](ctx, "timeStamp", m.GetTimeStamp(), WriteComplex[DateAndTime](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'timeStamp' field")
	}

	if err := WriteSimpleField[uint8](ctx, "functionId", m.GetFunctionId(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'functionId' field")
	}

	if err := WriteSimpleField[uint8](ctx, "numberOfObjects", m.GetNumberOfObjects(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'numberOfObjects' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "messageObjects", m.GetMessageObjects(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'messageObjects' field")
	}

	if popErr := writeBuffer.PopContext("AlarmMessageAckPushType"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for AlarmMessageAckPushType")
	}
	return nil
}

func (m *_AlarmMessageAckPushType) IsAlarmMessageAckPushType() {}

func (m *_AlarmMessageAckPushType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AlarmMessageAckPushType) deepCopy() *_AlarmMessageAckPushType {
	if m == nil {
		return nil
	}
	_AlarmMessageAckPushTypeCopy := &_AlarmMessageAckPushType{
		utils.DeepCopy[DateAndTime](m.TimeStamp),
		m.FunctionId,
		m.NumberOfObjects,
		utils.DeepCopySlice[AlarmMessageAckObjectPushType, AlarmMessageAckObjectPushType](m.MessageObjects),
	}
	return _AlarmMessageAckPushTypeCopy
}

func (m *_AlarmMessageAckPushType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
