/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetConfirmedServiceRequestSubscribeCOVProperty extends BACnetConfirmedServiceRequest
    implements Message {

  // Accessors for discriminator values.
  public BACnetConfirmedServiceChoice getServiceChoice() {
    return BACnetConfirmedServiceChoice.SUBSCRIBE_COV_PROPERTY;
  }

  // Properties.
  protected final BACnetContextTagUnsignedInteger subscriberProcessIdentifier;
  protected final BACnetContextTagObjectIdentifier monitoredObjectIdentifier;
  protected final BACnetContextTagBoolean issueConfirmedNotifications;
  protected final BACnetContextTagUnsignedInteger lifetime;
  protected final BACnetPropertyReferenceEnclosed monitoredPropertyIdentifier;
  protected final BACnetContextTagReal covIncrement;

  // Arguments.
  protected final Long serviceRequestLength;

  public BACnetConfirmedServiceRequestSubscribeCOVProperty(
      BACnetContextTagUnsignedInteger subscriberProcessIdentifier,
      BACnetContextTagObjectIdentifier monitoredObjectIdentifier,
      BACnetContextTagBoolean issueConfirmedNotifications,
      BACnetContextTagUnsignedInteger lifetime,
      BACnetPropertyReferenceEnclosed monitoredPropertyIdentifier,
      BACnetContextTagReal covIncrement,
      Long serviceRequestLength) {
    super(serviceRequestLength);
    this.subscriberProcessIdentifier = subscriberProcessIdentifier;
    this.monitoredObjectIdentifier = monitoredObjectIdentifier;
    this.issueConfirmedNotifications = issueConfirmedNotifications;
    this.lifetime = lifetime;
    this.monitoredPropertyIdentifier = monitoredPropertyIdentifier;
    this.covIncrement = covIncrement;
    this.serviceRequestLength = serviceRequestLength;
  }

  public BACnetContextTagUnsignedInteger getSubscriberProcessIdentifier() {
    return subscriberProcessIdentifier;
  }

  public BACnetContextTagObjectIdentifier getMonitoredObjectIdentifier() {
    return monitoredObjectIdentifier;
  }

  public BACnetContextTagBoolean getIssueConfirmedNotifications() {
    return issueConfirmedNotifications;
  }

  public BACnetContextTagUnsignedInteger getLifetime() {
    return lifetime;
  }

  public BACnetPropertyReferenceEnclosed getMonitoredPropertyIdentifier() {
    return monitoredPropertyIdentifier;
  }

  public BACnetContextTagReal getCovIncrement() {
    return covIncrement;
  }

  @Override
  protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetConfirmedServiceRequestSubscribeCOVProperty");

    // Simple Field (subscriberProcessIdentifier)
    writeSimpleField(
        "subscriberProcessIdentifier", subscriberProcessIdentifier, writeComplex(writeBuffer));

    // Simple Field (monitoredObjectIdentifier)
    writeSimpleField(
        "monitoredObjectIdentifier", monitoredObjectIdentifier, writeComplex(writeBuffer));

    // Optional Field (issueConfirmedNotifications) (Can be skipped, if the value is null)
    writeOptionalField(
        "issueConfirmedNotifications", issueConfirmedNotifications, writeComplex(writeBuffer));

    // Optional Field (lifetime) (Can be skipped, if the value is null)
    writeOptionalField("lifetime", lifetime, writeComplex(writeBuffer));

    // Simple Field (monitoredPropertyIdentifier)
    writeSimpleField(
        "monitoredPropertyIdentifier", monitoredPropertyIdentifier, writeComplex(writeBuffer));

    // Optional Field (covIncrement) (Can be skipped, if the value is null)
    writeOptionalField("covIncrement", covIncrement, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetConfirmedServiceRequestSubscribeCOVProperty");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetConfirmedServiceRequestSubscribeCOVProperty _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (subscriberProcessIdentifier)
    lengthInBits += subscriberProcessIdentifier.getLengthInBits();

    // Simple field (monitoredObjectIdentifier)
    lengthInBits += monitoredObjectIdentifier.getLengthInBits();

    // Optional Field (issueConfirmedNotifications)
    if (issueConfirmedNotifications != null) {
      lengthInBits += issueConfirmedNotifications.getLengthInBits();
    }

    // Optional Field (lifetime)
    if (lifetime != null) {
      lengthInBits += lifetime.getLengthInBits();
    }

    // Simple field (monitoredPropertyIdentifier)
    lengthInBits += monitoredPropertyIdentifier.getLengthInBits();

    // Optional Field (covIncrement)
    if (covIncrement != null) {
      lengthInBits += covIncrement.getLengthInBits();
    }

    return lengthInBits;
  }

  public static BACnetConfirmedServiceRequestBuilder
      staticParseBACnetConfirmedServiceRequestBuilder(
          ReadBuffer readBuffer, Long serviceRequestLength) throws ParseException {
    readBuffer.pullContext("BACnetConfirmedServiceRequestSubscribeCOVProperty");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagUnsignedInteger subscriberProcessIdentifier =
        readSimpleField(
            "subscriberProcessIdentifier",
            readComplex(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetContextTagObjectIdentifier monitoredObjectIdentifier =
        readSimpleField(
            "monitoredObjectIdentifier",
            readComplex(
                () ->
                    (BACnetContextTagObjectIdentifier)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (1),
                            (BACnetDataType) (BACnetDataType.BACNET_OBJECT_IDENTIFIER)),
                readBuffer));

    BACnetContextTagBoolean issueConfirmedNotifications =
        readOptionalField(
            "issueConfirmedNotifications",
            readComplex(
                () ->
                    (BACnetContextTagBoolean)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (2), (BACnetDataType) (BACnetDataType.BOOLEAN)),
                readBuffer));

    BACnetContextTagUnsignedInteger lifetime =
        readOptionalField(
            "lifetime",
            readComplex(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (3),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetPropertyReferenceEnclosed monitoredPropertyIdentifier =
        readSimpleField(
            "monitoredPropertyIdentifier",
            readComplex(
                () -> BACnetPropertyReferenceEnclosed.staticParse(readBuffer, (short) (4)),
                readBuffer));

    BACnetContextTagReal covIncrement =
        readOptionalField(
            "covIncrement",
            readComplex(
                () ->
                    (BACnetContextTagReal)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (5), (BACnetDataType) (BACnetDataType.REAL)),
                readBuffer));

    readBuffer.closeContext("BACnetConfirmedServiceRequestSubscribeCOVProperty");
    // Create the instance
    return new BACnetConfirmedServiceRequestSubscribeCOVPropertyBuilderImpl(
        subscriberProcessIdentifier,
        monitoredObjectIdentifier,
        issueConfirmedNotifications,
        lifetime,
        monitoredPropertyIdentifier,
        covIncrement,
        serviceRequestLength);
  }

  public static class BACnetConfirmedServiceRequestSubscribeCOVPropertyBuilderImpl
      implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
    private final BACnetContextTagUnsignedInteger subscriberProcessIdentifier;
    private final BACnetContextTagObjectIdentifier monitoredObjectIdentifier;
    private final BACnetContextTagBoolean issueConfirmedNotifications;
    private final BACnetContextTagUnsignedInteger lifetime;
    private final BACnetPropertyReferenceEnclosed monitoredPropertyIdentifier;
    private final BACnetContextTagReal covIncrement;
    private final Long serviceRequestLength;

    public BACnetConfirmedServiceRequestSubscribeCOVPropertyBuilderImpl(
        BACnetContextTagUnsignedInteger subscriberProcessIdentifier,
        BACnetContextTagObjectIdentifier monitoredObjectIdentifier,
        BACnetContextTagBoolean issueConfirmedNotifications,
        BACnetContextTagUnsignedInteger lifetime,
        BACnetPropertyReferenceEnclosed monitoredPropertyIdentifier,
        BACnetContextTagReal covIncrement,
        Long serviceRequestLength) {
      this.subscriberProcessIdentifier = subscriberProcessIdentifier;
      this.monitoredObjectIdentifier = monitoredObjectIdentifier;
      this.issueConfirmedNotifications = issueConfirmedNotifications;
      this.lifetime = lifetime;
      this.monitoredPropertyIdentifier = monitoredPropertyIdentifier;
      this.covIncrement = covIncrement;
      this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetConfirmedServiceRequestSubscribeCOVProperty build(Long serviceRequestLength) {

      BACnetConfirmedServiceRequestSubscribeCOVProperty
          bACnetConfirmedServiceRequestSubscribeCOVProperty =
              new BACnetConfirmedServiceRequestSubscribeCOVProperty(
                  subscriberProcessIdentifier,
                  monitoredObjectIdentifier,
                  issueConfirmedNotifications,
                  lifetime,
                  monitoredPropertyIdentifier,
                  covIncrement,
                  serviceRequestLength);
      return bACnetConfirmedServiceRequestSubscribeCOVProperty;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetConfirmedServiceRequestSubscribeCOVProperty)) {
      return false;
    }
    BACnetConfirmedServiceRequestSubscribeCOVProperty that =
        (BACnetConfirmedServiceRequestSubscribeCOVProperty) o;
    return (getSubscriberProcessIdentifier() == that.getSubscriberProcessIdentifier())
        && (getMonitoredObjectIdentifier() == that.getMonitoredObjectIdentifier())
        && (getIssueConfirmedNotifications() == that.getIssueConfirmedNotifications())
        && (getLifetime() == that.getLifetime())
        && (getMonitoredPropertyIdentifier() == that.getMonitoredPropertyIdentifier())
        && (getCovIncrement() == that.getCovIncrement())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getSubscriberProcessIdentifier(),
        getMonitoredObjectIdentifier(),
        getIssueConfirmedNotifications(),
        getLifetime(),
        getMonitoredPropertyIdentifier(),
        getCovIncrement());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
