/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SecuritySettingsDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15561;
  }

  // Properties.
  protected final PascalString name;
  protected final List<KeyValuePair> recordProperties;
  protected final List<MessageSecurityMode> securityModes;
  protected final List<PascalString> securityPolicyUris;
  protected final PascalString certificateGroupName;

  public SecuritySettingsDataType(
      PascalString name,
      List<KeyValuePair> recordProperties,
      List<MessageSecurityMode> securityModes,
      List<PascalString> securityPolicyUris,
      PascalString certificateGroupName) {
    super();
    this.name = name;
    this.recordProperties = recordProperties;
    this.securityModes = securityModes;
    this.securityPolicyUris = securityPolicyUris;
    this.certificateGroupName = certificateGroupName;
  }

  public PascalString getName() {
    return name;
  }

  public List<KeyValuePair> getRecordProperties() {
    return recordProperties;
  }

  public List<MessageSecurityMode> getSecurityModes() {
    return securityModes;
  }

  public List<PascalString> getSecurityPolicyUris() {
    return securityPolicyUris;
  }

  public PascalString getCertificateGroupName() {
    return certificateGroupName;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SecuritySettingsDataType");

    // Simple Field (name)
    writeSimpleField("name", name, writeComplex(writeBuffer));

    // Implicit Field (noOfRecordProperties) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfRecordProperties =
        (int) ((((getRecordProperties()) == (null)) ? -(1) : COUNT(getRecordProperties())));
    writeImplicitField(
        "noOfRecordProperties", noOfRecordProperties, writeSignedInt(writeBuffer, 32));

    // Array Field (recordProperties)
    writeComplexTypeArrayField("recordProperties", recordProperties, writeBuffer);

    // Implicit Field (noOfSecurityModes) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfSecurityModes =
        (int) ((((getSecurityModes()) == (null)) ? -(1) : COUNT(getSecurityModes())));
    writeImplicitField("noOfSecurityModes", noOfSecurityModes, writeSignedInt(writeBuffer, 32));

    // Array Field (securityModes)
    writeSimpleTypeArrayField(
        "securityModes",
        securityModes,
        writeEnum(
            MessageSecurityMode::getValue,
            MessageSecurityMode::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Implicit Field (noOfSecurityPolicyUris) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfSecurityPolicyUris =
        (int) ((((getSecurityPolicyUris()) == (null)) ? -(1) : COUNT(getSecurityPolicyUris())));
    writeImplicitField(
        "noOfSecurityPolicyUris", noOfSecurityPolicyUris, writeSignedInt(writeBuffer, 32));

    // Array Field (securityPolicyUris)
    writeComplexTypeArrayField("securityPolicyUris", securityPolicyUris, writeBuffer);

    // Simple Field (certificateGroupName)
    writeSimpleField("certificateGroupName", certificateGroupName, writeComplex(writeBuffer));

    writeBuffer.popContext("SecuritySettingsDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SecuritySettingsDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Implicit Field (noOfRecordProperties)
    lengthInBits += 32;

    // Array field
    if (recordProperties != null) {
      int i = 0;
      for (KeyValuePair element : recordProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= recordProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfSecurityModes)
    lengthInBits += 32;

    // Array field
    if (securityModes != null) {
      lengthInBits += 32 * securityModes.size();
    }

    // Implicit Field (noOfSecurityPolicyUris)
    lengthInBits += 32;

    // Array field
    if (securityPolicyUris != null) {
      int i = 0;
      for (PascalString element : securityPolicyUris) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= securityPolicyUris.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (certificateGroupName)
    lengthInBits += certificateGroupName.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("SecuritySettingsDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString name =
        readSimpleField(
            "name", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfRecordProperties =
        readImplicitField("noOfRecordProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> recordProperties =
        readCountArrayField(
            "recordProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfRecordProperties);

    int noOfSecurityModes = readImplicitField("noOfSecurityModes", readSignedInt(readBuffer, 32));

    List<MessageSecurityMode> securityModes =
        readCountArrayField(
            "securityModes",
            readEnum(MessageSecurityMode::enumForValue, readUnsignedLong(readBuffer, 32)),
            noOfSecurityModes);

    int noOfSecurityPolicyUris =
        readImplicitField("noOfSecurityPolicyUris", readSignedInt(readBuffer, 32));

    List<PascalString> securityPolicyUris =
        readCountArrayField(
            "securityPolicyUris",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfSecurityPolicyUris);

    PascalString certificateGroupName =
        readSimpleField(
            "certificateGroupName",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("SecuritySettingsDataType");
    // Create the instance
    return new SecuritySettingsDataTypeBuilderImpl(
        name, recordProperties, securityModes, securityPolicyUris, certificateGroupName);
  }

  public static class SecuritySettingsDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString name;
    private final List<KeyValuePair> recordProperties;
    private final List<MessageSecurityMode> securityModes;
    private final List<PascalString> securityPolicyUris;
    private final PascalString certificateGroupName;

    public SecuritySettingsDataTypeBuilderImpl(
        PascalString name,
        List<KeyValuePair> recordProperties,
        List<MessageSecurityMode> securityModes,
        List<PascalString> securityPolicyUris,
        PascalString certificateGroupName) {
      this.name = name;
      this.recordProperties = recordProperties;
      this.securityModes = securityModes;
      this.securityPolicyUris = securityPolicyUris;
      this.certificateGroupName = certificateGroupName;
    }

    public SecuritySettingsDataType build() {
      SecuritySettingsDataType securitySettingsDataType =
          new SecuritySettingsDataType(
              name, recordProperties, securityModes, securityPolicyUris, certificateGroupName);
      return securitySettingsDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SecuritySettingsDataType)) {
      return false;
    }
    SecuritySettingsDataType that = (SecuritySettingsDataType) o;
    return (getName() == that.getName())
        && (getRecordProperties() == that.getRecordProperties())
        && (getSecurityModes() == that.getSecurityModes())
        && (getSecurityPolicyUris() == that.getSecurityPolicyUris())
        && (getCertificateGroupName() == that.getCertificateGroupName())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getName(),
        getRecordProperties(),
        getSecurityModes(),
        getSecurityPolicyUris(),
        getCertificateGroupName());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
