/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus.metrics;

import java.io.IOException;
import java.io.Writer;
import org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.broker.stats.prometheus.metrics.DataSketchesOpStatsLogger;
import org.apache.pulsar.broker.stats.prometheus.metrics.SimpleGauge;

public class PrometheusTextFormatUtil {
    static void writeGauge(Writer w, String name, String cluster, SimpleGauge<? extends Number> gauge) {
        try {
            w.append("# TYPE ").append(name).append(" gauge\n");
            w.append(name).append("{cluster=\"").append(cluster).append("\"}").append(' ').append(gauge.getSample().toString()).append('\n');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void writeCounter(Writer w, String name, String cluster, Counter counter) {
        try {
            w.append("# TYPE ").append(name).append(" counter\n");
            w.append(name).append("{cluster=\"").append(cluster).append("\"}").append(' ').append(counter.get().toString()).append('\n');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void writeOpStat(Writer w, String name, String cluster, DataSketchesOpStatsLogger opStat) {
        try {
            w.append("# TYPE ").append(name).append(" summary\n");
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, false, 0.5);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, false, 0.75);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, false, 0.95);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, false, 0.99);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, false, 0.999);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, false, 0.9999);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, false, 1.0);
            PrometheusTextFormatUtil.writeCount(w, opStat, name, cluster, false);
            PrometheusTextFormatUtil.writeSum(w, opStat, name, cluster, false);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, true, 0.5);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, true, 0.75);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, true, 0.95);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, true, 0.99);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, true, 0.999);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, true, 0.9999);
            PrometheusTextFormatUtil.writeQuantile(w, opStat, name, cluster, true, 1.0);
            PrometheusTextFormatUtil.writeCount(w, opStat, name, cluster, true);
            PrometheusTextFormatUtil.writeSum(w, opStat, name, cluster, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeQuantile(Writer w, DataSketchesOpStatsLogger opStat, String name, String cluster, Boolean success, double quantile) throws IOException {
        w.append(name).append("{cluster=\"").append(cluster).append("\", success=\"").append(success.toString()).append("\", quantile=\"").append(Double.toString(quantile)).append("\"} ").append(Double.toString(opStat.getQuantileValue(success, quantile))).append('\n');
    }

    private static void writeCount(Writer w, DataSketchesOpStatsLogger opStat, String name, String cluster, Boolean success) throws IOException {
        w.append(name).append("_count{cluster=\"").append(cluster).append("\", success=\"").append(success.toString()).append("\"} ").append(Long.toString(opStat.getCount(success))).append('\n');
    }

    private static void writeSum(Writer w, DataSketchesOpStatsLogger opStat, String name, String cluster, Boolean success) throws IOException {
        w.append(name).append("_sum{cluster=\"").append(cluster).append("\", success=\"").append(success.toString()).append("\"} ").append(Double.toString(opStat.getSum(success))).append('\n');
    }
}

