/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.dlog;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.distributedlog.AppendOnlyStreamWriter;
import org.apache.distributedlog.api.DistributedLogManager;

public class DLOutputStream
extends OutputStream {
    private final DistributedLogManager dlm;
    private final AppendOnlyStreamWriter writer;

    public DLOutputStream(DistributedLogManager dlm, AppendOnlyStreamWriter writer) {
        this.dlm = dlm;
        this.writer = writer;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] data = new byte[]{(byte)b};
        this.write(data);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] newData = new byte[len];
        System.arraycopy(b, off, newData, 0, len);
        this.write(newData);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writer.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.writer.force(false);
    }

    @Override
    public void close() throws IOException {
        this.writer.markEndOfStream();
        this.writer.close();
        this.dlm.close();
    }
}

