/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.NavigableMap;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.PersistentOfflineTopicStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedLedgerOfflineBacklog {
    private final byte[] password;
    private final BookKeeper.DigestType digestType;
    private static final int META_READ_TIMEOUT_SECONDS = 60;
    private final boolean accurate;
    private final String brokerName;
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerOfflineBacklog.class);

    public ManagedLedgerOfflineBacklog(DigestType digestType, byte[] password, String brokerName, boolean accurate) {
        this.digestType = BookKeeper.DigestType.fromApiDigestType((DigestType)digestType);
        this.password = password;
        this.accurate = accurate;
        this.brokerName = brokerName;
    }

    private long getNumberOfEntries(Range<Position> range, NavigableMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgers) {
        boolean toIncluded;
        Position fromPosition = (Position)range.lowerEndpoint();
        boolean fromIncluded = range.lowerBoundType() == BoundType.CLOSED;
        Position toPosition = (Position)range.upperEndpoint();
        boolean bl = toIncluded = range.upperBoundType() == BoundType.CLOSED;
        if (fromPosition.getLedgerId() == toPosition.getLedgerId()) {
            long count = toPosition.getEntryId() - fromPosition.getEntryId() - 1L;
            count += fromIncluded ? 1L : 0L;
            return count += toIncluded ? 1L : 0L;
        }
        long count = 0L;
        count += toPosition.getEntryId();
        count += toIncluded ? 1L : 0L;
        MLDataFormats.ManagedLedgerInfo.LedgerInfo li = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledgers.get(fromPosition.getLedgerId());
        if (li != null) {
            count += li.getEntries() - (fromPosition.getEntryId() + 1L);
            count += fromIncluded ? 1L : 0L;
        }
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : ledgers.subMap(fromPosition.getLedgerId(), false, toPosition.getLedgerId(), false).values()) {
            count += ls.getEntries();
        }
        return count;
    }

    public PersistentOfflineTopicStats getEstimatedUnloadedTopicBacklog(ManagedLedgerFactory factory, String managedLedgerName) throws Exception {
        return this.estimateUnloadedTopicBacklog(factory, TopicName.get((String)("persistent://" + managedLedgerName)));
    }

    public PersistentOfflineTopicStats estimateUnloadedTopicBacklog(ManagedLedgerFactory factory, TopicName topicName) throws Exception {
        String managedLedgerName = topicName.getPersistenceNamingEncoding();
        PersistentOfflineTopicStats offlineTopicStats = new PersistentOfflineTopicStats(managedLedgerName, this.brokerName);
        if (factory instanceof ManagedLedgerFactoryImpl) {
            ArrayList<Object> ctx = new ArrayList<Object>();
            ctx.add(this.digestType);
            ctx.add(this.password);
            factory.estimateUnloadedTopicBacklog(offlineTopicStats, topicName, this.accurate, ctx);
        } else {
            Object ctx = null;
            factory.estimateUnloadedTopicBacklog(offlineTopicStats, topicName, this.accurate, ctx);
        }
        return offlineTopicStats;
    }
}

