/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus.metrics;

import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesUnion;
import com.yahoo.sketches.quantiles.DoublesUnionBuilder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.broker.stats.prometheus.metrics.ThreadLocalAccessor;

public class DataSketchesSummaryLogger {
    private volatile ThreadLocalAccessor current;
    private volatile ThreadLocalAccessor replacement;
    private volatile DoublesSketch values;
    private final LongAdder countAdder = new LongAdder();
    private final LongAdder sumAdder = new LongAdder();

    public DataSketchesSummaryLogger() {
        this.current = new ThreadLocalAccessor();
        this.replacement = new ThreadLocalAccessor();
    }

    public void registerEvent(long eventLatency, TimeUnit unit) {
        double valueMillis = (double)unit.toMicros(eventLatency) / 1000.0;
        this.countAdder.increment();
        this.sumAdder.add((long)valueMillis);
        this.current.getLocalData().updateSuccess(valueMillis);
    }

    public void rotateLatencyCollection() {
        ThreadLocalAccessor local = this.current;
        this.current = this.replacement;
        this.replacement = local;
        DoublesUnion aggregateValues = new DoublesUnionBuilder().build();
        local.record(aggregateValues, null);
        this.values = aggregateValues.getResultAndReset();
    }

    public long getCount() {
        return this.countAdder.sum();
    }

    public long getSum() {
        return this.sumAdder.sum();
    }

    public double getQuantileValue(double quantile) {
        DoublesSketch s = this.values;
        return s != null ? s.getQuantile(quantile) : Double.NaN;
    }
}

