/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogWriteHandler;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.util.Utils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTruncate
extends TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestTruncate.class);
    protected static DistributedLogConfiguration conf = new DistributedLogConfiguration().setLockTimeout(10L).setOutputBufferSize(0).setPeriodicFlushFrequencyMilliSeconds(10).setSchedulerShutdownTimeoutMs(0).setDLLedgerMetadataLayoutVersion(LogSegmentMetadata.LogSegmentMetadataVersion.VERSION_V2_LEDGER_SEQNO.value);

    static void updateCompletionTime(ZooKeeperClient zkc, LogSegmentMetadata l, long completionTime) throws Exception {
        LogSegmentMetadata newSegment = l.mutator().setCompletionTime(completionTime).build();
        DLMTestUtil.updateSegmentMetadata(zkc, newSegment);
    }

    static void setTruncationStatus(ZooKeeperClient zkc, LogSegmentMetadata l, LogSegmentMetadata.TruncationStatus status) throws Exception {
        LogSegmentMetadata newSegment = l.mutator().setTruncationStatus(status).build();
        DLMTestUtil.updateSegmentMetadata(zkc, newSegment);
    }

    @Test(timeout=60000L)
    public void testPurgeLogs() throws Exception {
        String name = "distrlog-purge-logs";
        URI uri = this.createDLMURI("/" + name);
        this.populateData(new HashMap<Long, DLSN>(), conf, name, 10, 10, false);
        BKDistributedLogManager distributedLogManager = this.createNewDLM(conf, name);
        List segments = distributedLogManager.getLogSegments();
        LOG.info("Segments before modifying completion time : {}", (Object)segments);
        ZooKeeperClient zkc = TestZooKeeperClientBuilder.newBuilder(conf).uri(uri).build();
        long newTimeMs = System.currentTimeMillis() - 0x6DDD00L;
        for (int i = 0; i < 5; ++i) {
            LogSegmentMetadata segment = (LogSegmentMetadata)segments.get(i);
            TestTruncate.updateCompletionTime(zkc, segment, newTimeMs + (long)i);
        }
        zkc.close();
        segments = distributedLogManager.getLogSegments();
        LOG.info("Segments after modifying completion time : {}", (Object)segments);
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setRetentionPeriodHours(1);
        confLocal.setExplicitTruncationByApplication(false);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        AsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
        long txid = 101L;
        for (int j = 1; j <= 10; ++j) {
            Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(txid++)));
        }
        BKAsyncLogWriter bkLogWriter = (BKAsyncLogWriter)writer;
        CompletableFuture truncationAttempt = bkLogWriter.getLastTruncationAttempt();
        while (truncationAttempt == null || !truncationAttempt.isDone()) {
            TimeUnit.MILLISECONDS.sleep(20L);
            truncationAttempt = bkLogWriter.getLastTruncationAttempt();
        }
        Assert.assertEquals((long)6L, (long)distributedLogManager.getLogSegments().size());
        Utils.close((AsyncCloseable)writer);
        dlm.close();
        distributedLogManager.close();
    }

    @Test(timeout=60000L)
    public void testTruncation() throws Exception {
        String name = "distrlog-truncation";
        long txid = 1L;
        HashMap<Long, DLSN> txid2DLSN = new HashMap<Long, DLSN>();
        Pair<DistributedLogManager, AsyncLogWriter> pair = this.populateData(txid2DLSN, conf, name, 4, 10, true);
        Thread.sleep(1000L);
        Assert.assertFalse((boolean)((Boolean)Utils.ioResult((CompletableFuture)((AsyncLogWriter)pair.getRight()).truncate(DLSN.InvalidDLSN))));
        this.verifyEntries(name, 1L, 1L, 50);
        for (int i = 1; i <= 4; ++i) {
            int txn = (i - 1) * 10 + i;
            DLSN dlsn = (DLSN)txid2DLSN.get(txn);
            Assert.assertTrue((boolean)((Boolean)Utils.ioResult((CompletableFuture)((AsyncLogWriter)pair.getRight()).truncate(dlsn))));
            this.verifyEntries(name, 1L, (i - 1) * 10 + 1, (5 - i + 1) * 10);
        }
        int txn = 43;
        DLSN dlsn = (DLSN)txid2DLSN.get(txn);
        Assert.assertTrue((boolean)((Boolean)Utils.ioResult((CompletableFuture)((AsyncLogWriter)pair.getRight()).truncate(dlsn))));
        this.verifyEntries(name, 1L, 41L, 10);
        Utils.close((AsyncCloseable)((AsyncCloseable)pair.getRight()));
        ((DistributedLogManager)pair.getLeft()).close();
    }

    @Test(timeout=60000L)
    public void testExplicitTruncation() throws Exception {
        String name = "distrlog-truncation-explicit";
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setExplicitTruncationByApplication(true);
        HashMap<Long, DLSN> txid2DLSN = new HashMap<Long, DLSN>();
        Pair<DistributedLogManager, AsyncLogWriter> pair = this.populateData(txid2DLSN, confLocal, name, 4, 10, true);
        Thread.sleep(1000L);
        for (int i = 1; i <= 4; ++i) {
            int txn = (i - 1) * 10 + i;
            DLSN dlsn = (DLSN)txid2DLSN.get(txn);
            Assert.assertTrue((boolean)((Boolean)Utils.ioResult((CompletableFuture)((AsyncLogWriter)pair.getRight()).truncate(dlsn))));
            this.verifyEntries(name, 1L, (i - 1) * 10 + 1, (5 - i + 1) * 10);
        }
        int txn = 43;
        DLSN dlsn = (DLSN)txid2DLSN.get(txn);
        Assert.assertTrue((boolean)((Boolean)Utils.ioResult((CompletableFuture)((AsyncLogWriter)pair.getRight()).truncate(dlsn))));
        this.verifyEntries(name, 1L, 41L, 10);
        Utils.close((AsyncCloseable)((AsyncCloseable)pair.getRight()));
        ((DistributedLogManager)pair.getLeft()).close();
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        BKLogWriteHandler handler = dlm.createWriteHandler(true);
        Utils.ioResult((CompletableFuture)handler.purgeLogSegmentsOlderThanTxnId(Integer.MAX_VALUE));
        this.verifyEntries(name, 1L, 41L, 10);
    }

    @Test(timeout=60000L)
    public void testOnlyPurgeSegmentsBeforeNoneFullyTruncatedSegment() throws Exception {
        String name = "distrlog-only-purge-segments-before-none-fully-truncated-segment";
        URI uri = this.createDLMURI("/" + name);
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)conf);
        confLocal.setExplicitTruncationByApplication(true);
        this.populateData(new HashMap<Long, DLSN>(), confLocal, name, 4, 10, false);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        List segments = dlm.getLogSegments();
        LOG.info("Segments before modifying segment status : {}", (Object)segments);
        ZooKeeperClient zkc = TestZooKeeperClientBuilder.newBuilder(conf).uri(uri).build();
        TestTruncate.setTruncationStatus(zkc, (LogSegmentMetadata)segments.get(0), LogSegmentMetadata.TruncationStatus.PARTIALLY_TRUNCATED);
        for (int i = 1; i < 4; ++i) {
            LogSegmentMetadata segment = (LogSegmentMetadata)segments.get(i);
            TestTruncate.setTruncationStatus(zkc, segment, LogSegmentMetadata.TruncationStatus.TRUNCATED);
        }
        List segmentsAfterTruncated = dlm.getLogSegments();
        dlm.purgeLogsOlderThan(999999L);
        List newSegments = dlm.getLogSegments();
        LOG.info("Segments after purge segments older than 999999 : {}", (Object)newSegments);
        Assert.assertArrayEquals((Object[])segmentsAfterTruncated.toArray(new LogSegmentMetadata[segmentsAfterTruncated.size()]), (Object[])newSegments.toArray(new LogSegmentMetadata[newSegments.size()]));
        dlm.close();
        long newTimeMs = System.currentTimeMillis() - 36000000L;
        for (int i = 0; i < 4; ++i) {
            LogSegmentMetadata segment = (LogSegmentMetadata)newSegments.get(i);
            TestTruncate.updateCompletionTime(zkc, segment, newTimeMs + (long)i);
        }
        DistributedLogConfiguration newConf = new DistributedLogConfiguration();
        newConf.addConfiguration((Configuration)confLocal);
        newConf.setRetentionPeriodHours(1);
        BKDistributedLogManager newDLM = this.createNewDLM(newConf, name);
        AsyncLogWriter newWriter = newDLM.startAsyncLogSegmentNonPartitioned();
        long txid = 41L;
        for (int j = 1; j <= 10; ++j) {
            Utils.ioResult((CompletableFuture)newWriter.write(DLMTestUtil.getLogRecordInstance(txid++)));
        }
        DLSN lastDLSN = (DLSN)Utils.ioResult((CompletableFuture)newDLM.getLastDLSNAsync());
        LOG.info("Get last dlsn of stream {} : {}", (Object)name, (Object)lastDLSN);
        Assert.assertEquals((long)5L, (long)newDLM.getLogSegments().size());
        Utils.close((AsyncCloseable)newWriter);
        newDLM.close();
        zkc.close();
    }

    @Test(timeout=60000L)
    public void testPartiallyTruncateTruncatedSegments() throws Exception {
        String name = "distrlog-partially-truncate-truncated-segments";
        URI uri = this.createDLMURI("/" + name);
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)conf);
        confLocal.setExplicitTruncationByApplication(true);
        HashMap<Long, DLSN> dlsnMap = new HashMap<Long, DLSN>();
        this.populateData(dlsnMap, confLocal, name, 4, 10, false);
        BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
        List segments = dlm.getLogSegments();
        LOG.info("Segments before modifying segment status : {}", (Object)segments);
        ZooKeeperClient zkc = TestZooKeeperClientBuilder.newBuilder(conf).uri(uri).build();
        for (int i = 0; i < 4; ++i) {
            LogSegmentMetadata segment = (LogSegmentMetadata)segments.get(i);
            TestTruncate.setTruncationStatus(zkc, segment, LogSegmentMetadata.TruncationStatus.TRUNCATED);
        }
        List newSegments = dlm.getLogSegments();
        LOG.info("Segments after changing truncation status : {}", (Object)newSegments);
        dlm.close();
        BKDistributedLogManager newDLM = this.createNewDLM(confLocal, name);
        AsyncLogWriter newWriter = newDLM.startAsyncLogSegmentNonPartitioned();
        Utils.ioResult((CompletableFuture)newWriter.truncate((DLSN)dlsnMap.get(15L)));
        List newSegments2 = newDLM.getLogSegments();
        Assert.assertArrayEquals((Object[])newSegments.toArray(new LogSegmentMetadata[4]), (Object[])newSegments2.toArray(new LogSegmentMetadata[4]));
        Utils.close((AsyncCloseable)newWriter);
        newDLM.close();
        zkc.close();
    }

    private Pair<DistributedLogManager, AsyncLogWriter> populateData(Map<Long, DLSN> txid2DLSN, DistributedLogConfiguration confLocal, String name, int numLogSegments, int numEntriesPerLogSegment, boolean createInprogressLogSegment) throws Exception {
        long txid = 1L;
        for (long i = 1L; i <= (long)numLogSegments; ++i) {
            LOG.info("Writing Log Segment {}.", (Object)i);
            BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
            AsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
            for (int j = 1; j <= numEntriesPerLogSegment; ++j) {
                long curTxId;
                ++txid;
                DLSN dlsn = (DLSN)Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(curTxId)));
                txid2DLSN.put(curTxId, dlsn);
            }
            Utils.close((AsyncCloseable)writer);
            dlm.close();
        }
        if (createInprogressLogSegment) {
            BKDistributedLogManager dlm = this.createNewDLM(confLocal, name);
            AsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
            for (int j = 1; j <= 10; ++j) {
                long curTxId;
                ++txid;
                DLSN dlsn = (DLSN)Utils.ioResult((CompletableFuture)writer.write(DLMTestUtil.getLogRecordInstance(curTxId)));
                txid2DLSN.put(curTxId, dlsn);
            }
            return new ImmutablePair((Object)dlm, (Object)writer);
        }
        return null;
    }

    private void verifyEntries(String name, long readFromTxId, long startTxId, int numEntries) throws Exception {
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        LogReader reader = dlm.getInputStream(readFromTxId);
        long txid = startTxId;
        int numRead = 0;
        LogRecordWithDLSN r = reader.readNext(false);
        while (null != r) {
            DLMTestUtil.verifyLogRecord((LogRecord)r);
            Assert.assertEquals((long)txid++, (long)r.getTransactionId());
            ++numRead;
            r = reader.readNext(false);
        }
        Assert.assertEquals((long)numEntries, (long)numRead);
        reader.close();
        dlm.close();
    }
}

