/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.stats.AllocatorStats;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations to collect broker statistics"})
public class CmdBrokerStats
extends CmdBase {
    private static final String DEFAULT_INDENTATION = "    ";

    public CmdBrokerStats(Supplier<PulsarAdmin> admin) {
        super("broker-stats", admin);
        this.addCommand("monitoring-metrics", new CmdMonitoringMetrics());
        this.addCommand("mbeans", new CmdDumpMBeans());
        this.addCommand("topics", new CmdTopics(), "destinations");
        this.addCommand("allocator-stats", new CmdAllocatorStats());
        this.addCommand("load-report", new CmdLoadReport());
    }

    @CommandLine.Command(description={"dump metrics for Monitoring"})
    private class CmdMonitoringMetrics
    extends CliCommand {
        @CommandLine.Option(names={"-i", "--indent"}, description={"Indent JSON output"}, required=false)
        private boolean indent = false;

        private CmdMonitoringMetrics() {
        }

        @Override
        void run() throws Exception {
            String s = CmdBrokerStats.this.getAdmin().brokerStats().getMetrics();
            JsonArray metrics = (JsonArray)new Gson().fromJson(s, JsonArray.class);
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
                 JsonWriter jsonWriter = new JsonWriter((Writer)out);){
                for (int i = 0; i < metrics.size(); ++i) {
                    JsonObject m = (JsonObject)metrics.get(i);
                    if (this.indent) {
                        jsonWriter.setIndent(CmdBrokerStats.DEFAULT_INDENTATION);
                        new Gson().toJson((JsonElement)m, jsonWriter);
                        ((Writer)out).write(10);
                        ((Writer)out).write(10);
                    } else {
                        new Gson().toJson((JsonElement)m, jsonWriter);
                    }
                    ((Writer)out).flush();
                }
            }
        }
    }

    @CommandLine.Command(description={"dump mbean stats"})
    private class CmdDumpMBeans
    extends CliCommand {
        @CommandLine.Option(names={"-i", "--indent"}, description={"Indent JSON output"}, required=false)
        private boolean indent = false;

        private CmdDumpMBeans() {
        }

        @Override
        void run() throws Exception {
            String s = CmdBrokerStats.this.getAdmin().brokerStats().getMBeans();
            JsonArray result = (JsonArray)new Gson().fromJson(s, JsonArray.class);
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
                 JsonWriter jsonWriter = new JsonWriter((Writer)out);){
                if (this.indent) {
                    jsonWriter.setIndent(CmdBrokerStats.DEFAULT_INDENTATION);
                }
                new Gson().toJson((JsonElement)result, jsonWriter);
                ((Writer)out).flush();
            }
        }
    }

    @CommandLine.Command(description={"dump topics stats"})
    private class CmdTopics
    extends CliCommand {
        @CommandLine.Option(names={"-i", "--indent"}, description={"Indent JSON output"}, required=false)
        private boolean indent = false;

        private CmdTopics() {
        }

        @Override
        void run() throws Exception {
            String s = CmdBrokerStats.this.getAdmin().brokerStats().getTopics();
            JsonObject result = (JsonObject)new Gson().fromJson(s, JsonObject.class);
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
                 JsonWriter jsonWriter = new JsonWriter((Writer)out);){
                if (this.indent) {
                    jsonWriter.setIndent(CmdBrokerStats.DEFAULT_INDENTATION);
                }
                new Gson().toJson((JsonElement)result, jsonWriter);
                ((Writer)out).flush();
            }
        }
    }

    @CommandLine.Command(description={"dump allocator stats"})
    private class CmdAllocatorStats
    extends CliCommand {
        @CommandLine.Parameters(description={"allocator-name"}, arity="1")
        private String allocatorName;

        private CmdAllocatorStats() {
        }

        @Override
        void run() throws Exception {
            AllocatorStats stats = CmdBrokerStats.this.getAdmin().brokerStats().getAllocatorStats(this.allocatorName);
            ObjectMapper mapper = ObjectMapperFactory.create();
            ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);){
                out.write(writer.writeValueAsString((Object)stats));
                ((Writer)out).flush();
            }
        }
    }

    @CommandLine.Command(description={"dump broker load-report"})
    private class CmdLoadReport
    extends CliCommand {
        private CmdLoadReport() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBrokerStats.this.getAdmin().brokerStats().getLoadReport());
        }
    }
}

