/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.impl.OpAddEntry;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.mledger.util.Errors;
import org.apache.pulsar.metadata.api.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadowManagedLedgerImpl
extends ManagedLedgerImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShadowManagedLedgerImpl.class);
    private final String sourceMLName;
    private volatile Stat sourceLedgersStat;

    public ShadowManagedLedgerImpl(ManagedLedgerFactoryImpl factory, BookKeeper bookKeeper, MetaStore store, ManagedLedgerConfig config, OrderedScheduler scheduledExecutor, String name, Supplier<CompletableFuture<Boolean>> mlOwnershipChecker) {
        super(factory, bookKeeper, store, config, scheduledExecutor, name, mlOwnershipChecker);
        this.sourceMLName = config.getShadowSourceName();
        this.currentLedgerTimeoutTriggered = new AtomicBoolean(false);
    }

    @Override
    synchronized void initialize(ManagedLedgerImpl.ManagedLedgerInitializeLedgerCallback callback, Object ctx) {
        log.info("Opening shadow managed ledger {} with source={}", (Object)this.name, (Object)this.sourceMLName);
        this.executor.execute(() -> this.doInitialize(callback, ctx));
    }

    private void doInitialize(final ManagedLedgerImpl.ManagedLedgerInitializeLedgerCallback callback, final Object ctx) {
        this.store.watchManagedLedgerInfo(this.sourceMLName, (managedLedgerInfo, stat) -> this.executor.execute(() -> this.processSourceManagedLedgerInfo((MLDataFormats.ManagedLedgerInfo)managedLedgerInfo, stat)));
        this.store.getManagedLedgerInfo(this.sourceMLName, false, null, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            @Override
            public void operationComplete(MLDataFormats.ManagedLedgerInfo mlInfo, Stat stat) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Source ML info:{}", new Object[]{ShadowManagedLedgerImpl.this.name, ShadowManagedLedgerImpl.this.sourceMLName, mlInfo});
                }
                if (ShadowManagedLedgerImpl.this.sourceLedgersStat != null && ShadowManagedLedgerImpl.this.sourceLedgersStat.getVersion() >= stat.getVersion()) {
                    log.warn("Newer version of mlInfo is already processed. Previous stat={}, current stat={}", (Object)ShadowManagedLedgerImpl.this.sourceLedgersStat, (Object)stat);
                    return;
                }
                ShadowManagedLedgerImpl.this.sourceLedgersStat = stat;
                if (mlInfo.getLedgerInfoCount() == 0) {
                    log.warn("[{}] Source topic ledger list is empty! source={},mlInfo={},stat={}", new Object[]{ShadowManagedLedgerImpl.this.name, ShadowManagedLedgerImpl.this.sourceMLName, mlInfo, stat});
                    ShadowManagedLedgerImpl.super.initialize(callback, ctx);
                    return;
                }
                if (mlInfo.hasTerminatedPosition()) {
                    MLDataFormats.NestedPositionInfo terminatedPosition = mlInfo.getTerminatedPosition();
                    ShadowManagedLedgerImpl.this.lastConfirmedEntry = PositionFactory.create(terminatedPosition.getLedgerId(), terminatedPosition.getEntryId());
                    log.info("[{}][{}] Recovering managed ledger terminated at {}", new Object[]{ShadowManagedLedgerImpl.this.name, ShadowManagedLedgerImpl.this.sourceMLName, ShadowManagedLedgerImpl.this.lastConfirmedEntry});
                }
                for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : mlInfo.getLedgerInfoList()) {
                    ShadowManagedLedgerImpl.this.ledgers.put(ls.getLedgerId(), ls);
                }
                long lastLedgerId = (Long)ShadowManagedLedgerImpl.this.ledgers.lastKey();
                ShadowManagedLedgerImpl.this.mbean.startDataLedgerOpenOp();
                AsyncCallback.OpenCallback opencb = (rc, lh, ctx1) -> ShadowManagedLedgerImpl.this.executor.execute(() -> {
                    ShadowManagedLedgerImpl.this.mbean.endDataLedgerOpenOp();
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Opened source ledger {}", (Object)ShadowManagedLedgerImpl.this.name, (Object)lastLedgerId);
                    }
                    if (rc == 0) {
                        MLDataFormats.ManagedLedgerInfo.LedgerInfo info = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(lastLedgerId).setEntries(lh.getLastAddConfirmed() + 1L).setSize(lh.getLength()).setTimestamp(ShadowManagedLedgerImpl.this.clock.millis()).build();
                        ShadowManagedLedgerImpl.this.ledgers.put(lastLedgerId, info);
                        ManagedLedgerImpl.STATE_UPDATER.set(ShadowManagedLedgerImpl.this, ManagedLedgerImpl.State.LedgerOpened);
                        ShadowManagedLedgerImpl.this.currentLedger = lh;
                        if (ShadowManagedLedgerImpl.this.managedLedgerInterceptor != null) {
                            ((CompletableFuture)ShadowManagedLedgerImpl.this.managedLedgerInterceptor.onManagedLedgerLastLedgerInitialize(ShadowManagedLedgerImpl.this.name, ShadowManagedLedgerImpl.this.createLastEntryHandle(lh)).thenRun(() -> ShadowManagedLedgerImpl.super.initialize(callback, ctx))).exceptionally(ex -> {
                                callback.initializeFailed(new ManagedLedgerException.ManagedLedgerInterceptException(ex.getCause()));
                                return null;
                            });
                        } else {
                            ShadowManagedLedgerImpl.super.initialize(callback, ctx);
                        }
                    } else if (Errors.isNoSuchLedgerExistsException(rc)) {
                        log.warn("[{}] Source ledger not found: {}", (Object)ShadowManagedLedgerImpl.this.name, (Object)lastLedgerId);
                        ShadowManagedLedgerImpl.this.ledgers.remove(lastLedgerId);
                        ShadowManagedLedgerImpl.super.initialize(callback, ctx);
                    } else {
                        log.error("[{}] Failed to open source ledger {}: {}", new Object[]{ShadowManagedLedgerImpl.this.name, lastLedgerId, BKException.getMessage((int)rc)});
                        callback.initializeFailed(ManagedLedgerImpl.createManagedLedgerException(rc));
                    }
                });
                ShadowManagedLedgerImpl.this.bookKeeper.asyncOpenLedgerNoRecovery(lastLedgerId, ShadowManagedLedgerImpl.this.digestType, ShadowManagedLedgerImpl.this.config.getPassword(), opencb, null);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                if (e instanceof ManagedLedgerException.MetadataNotFoundException) {
                    callback.initializeFailed(new ManagedLedgerException.ManagedLedgerNotFoundException(e));
                } else {
                    callback.initializeFailed(new ManagedLedgerException(e));
                }
            }
        });
    }

    @Override
    protected synchronized void initializeBookKeeper(final ManagedLedgerImpl.ManagedLedgerInitializeLedgerCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] initializing bookkeeper for shadowManagedLedger; ledgers {}", (Object)this.name, (Object)this.ledgers);
        }
        Iterator iterator = this.ledgers.values().iterator();
        while (iterator.hasNext()) {
            MLDataFormats.ManagedLedgerInfo.LedgerInfo li = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)iterator.next();
            if (li.getEntries() > 0L) {
                NUMBER_OF_ENTRIES_UPDATER.addAndGet(this, li.getEntries());
                TOTAL_SIZE_UPDATER.addAndGet(this, li.getSize());
                continue;
            }
            if (li.getLedgerId() == this.currentLedger.getId()) continue;
            iterator.remove();
        }
        this.initLastConfirmedEntry();
        this.store.asyncUpdateLedgerIds(this.name, this.getManagedLedgerInfo(), this.ledgersStat, new MetaStore.MetaStoreCallback<Void>(){

            @Override
            public void operationComplete(Void result, Stat stat) {
                ShadowManagedLedgerImpl.this.ledgersStat = stat;
                ShadowManagedLedgerImpl.this.initializeCursors(callback);
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                ShadowManagedLedgerImpl.this.handleBadVersion(e);
                callback.initializeFailed(new ManagedLedgerException(e));
            }
        });
    }

    private void initLastConfirmedEntry() {
        Map.Entry formerLedger;
        if (this.currentLedger == null) {
            return;
        }
        this.lastConfirmedEntry = PositionFactory.create(this.currentLedger.getId(), this.currentLedger.getLastAddConfirmed());
        while (this.lastConfirmedEntry.getEntryId() == -1L && (formerLedger = this.ledgers.lowerEntry(this.lastConfirmedEntry.getLedgerId())) != null) {
            MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)formerLedger.getValue();
            this.lastConfirmedEntry = PositionFactory.create(ledgerInfo.getLedgerId(), ledgerInfo.getEntries() - 1L);
        }
    }

    @Override
    protected synchronized void internalAsyncAddEntry(OpAddEntry addOperation) {
        Object object;
        if (!this.beforeAddEntry(addOperation)) {
            return;
        }
        if (this.state != ManagedLedgerImpl.State.LedgerOpened) {
            addOperation.failed(new ManagedLedgerException("Managed ledger is not opened"));
            return;
        }
        if (addOperation.getCtx() == null || !((object = addOperation.getCtx()) instanceof Position)) {
            addOperation.failed(new ManagedLedgerException("Illegal addOperation context object."));
            return;
        }
        Position position = (Position)object;
        if (log.isDebugEnabled()) {
            log.debug("[{}] Add entry into shadow ledger lh={} entries={}, pos=({},{})", new Object[]{this.name, this.currentLedger.getId(), this.currentLedgerEntries, position.getLedgerId(), position.getEntryId()});
        }
        this.pendingAddEntries.add(addOperation);
        if (position.getLedgerId() <= this.currentLedger.getId()) {
            if (position.getLedgerId() == this.currentLedger.getId()) {
                addOperation.setLedger(this.currentLedger);
            }
            this.currentLedgerEntries = position.getEntryId();
            this.currentLedgerSize += (long)addOperation.data.readableBytes();
            addOperation.initiateShadowWrite();
        }
        this.lastAddEntryTimeMs = System.currentTimeMillis();
    }

    @Override
    public synchronized void asyncTerminate(AsyncCallbacks.TerminateCallback callback, Object ctx) {
        callback.terminateFailed(new ManagedLedgerException("Terminate is not allowed on shadow topic."), ctx);
    }

    private synchronized void processSourceManagedLedgerInfo(MLDataFormats.ManagedLedgerInfo mlInfo, Stat stat) {
        ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo> arrayList;
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] new SourceManagedLedgerInfo:{}, prevStat={},stat={}", new Object[]{this.name, this.sourceMLName, mlInfo, this.sourceLedgersStat, stat});
        }
        if (this.sourceLedgersStat != null && this.sourceLedgersStat.getVersion() >= stat.getVersion()) {
            log.warn("Newer version of mlInfo is already processed. Previous stat={}, current stat={}", (Object)this.sourceLedgersStat, (Object)stat);
            return;
        }
        this.sourceLedgersStat = stat;
        if (mlInfo.hasTerminatedPosition()) {
            MLDataFormats.NestedPositionInfo terminatedPosition = mlInfo.getTerminatedPosition();
            this.lastConfirmedEntry = PositionFactory.create(terminatedPosition.getLedgerId(), terminatedPosition.getEntryId());
            log.info("[{}][{}] Process managed ledger terminated at {}", new Object[]{this.name, this.sourceMLName, this.lastConfirmedEntry});
        }
        TreeMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> newLedgerInfos = new TreeMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo : mlInfo.getLedgerInfoList()) {
            newLedgerInfos.put(ledgerInfo.getLedgerId(), ledgerInfo);
        }
        for (Map.Entry entry : newLedgerInfos.entrySet()) {
            Long ledgerId = (Long)entry.getKey();
            MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)entry.getValue();
            if (ledgerInfo.getEntries() <= 0L) continue;
            MLDataFormats.ManagedLedgerInfo.LedgerInfo oldLedgerInfo = this.ledgers.put(ledgerId, ledgerInfo);
            if (oldLedgerInfo == null) {
                log.info("[{}]Read new ledger info from source,ledgerId={}", (Object)this.name, (Object)ledgerId);
                continue;
            }
            if (oldLedgerInfo.equals(ledgerInfo)) continue;
            log.info("[{}] Old ledger info updated in source,ledgerId={}", (Object)this.name, (Object)ledgerId);
            if (!ledgerInfo.hasOffloadContext() || !ledgerInfo.getOffloadContext().getBookkeeperDeleted() || oldLedgerInfo.hasOffloadContext() && oldLedgerInfo.getOffloadContext().getBookkeeperDeleted()) continue;
            log.info("[{}] Old ledger removed from bookkeeper by offloader in source,ledgerId={}", (Object)this.name, (Object)ledgerId);
            this.invalidateReadHandle(ledgerId);
        }
        Long lastLedgerId = (Long)newLedgerInfos.lastKey();
        if (lastLedgerId != null && (this.currentLedger == null || this.currentLedger.getId() != lastLedgerId.longValue())) {
            this.ledgers.put(lastLedgerId, (MLDataFormats.ManagedLedgerInfo.LedgerInfo)newLedgerInfos.get(lastLedgerId));
            this.mbean.startDataLedgerOpenOp();
            this.bookKeeper.asyncOpenLedgerNoRecovery(lastLedgerId.longValue(), this.digestType, this.config.getPassword(), (rc, lh, ctx1) -> this.executor.execute(() -> {
                this.mbean.endDataLedgerOpenOp();
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Opened new source ledger {}", (Object)this.name, (Object)lastLedgerId);
                }
                if (rc == 0) {
                    MLDataFormats.ManagedLedgerInfo.LedgerInfo info = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(lastLedgerId).setEntries(lh.getLastAddConfirmed() + 1L).setSize(lh.getLength()).setTimestamp(this.clock.millis()).build();
                    this.ledgers.put(lastLedgerId, info);
                    this.currentLedger = lh;
                    this.currentLedgerEntries = 0L;
                    this.currentLedgerSize = 0L;
                    this.initLastConfirmedEntry();
                    this.updateLedgersIdsComplete(null);
                    this.maybeUpdateCursorBeforeTrimmingConsumedLedger();
                } else if (Errors.isNoSuchLedgerExistsException(rc)) {
                    log.warn("[{}] Source ledger not found: {}", (Object)this.name, (Object)lastLedgerId);
                    this.ledgers.remove(lastLedgerId);
                } else {
                    log.error("[{}] Failed to open source ledger {}: {}", new Object[]{this.name, lastLedgerId, BKException.getMessage((int)rc)});
                }
            }), null);
        }
        if (!(arrayList = new ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo>(this.ledgers.headMap((Long)newLedgerInfos.firstKey(), false).values())).isEmpty()) {
            log.info("[{}]ledgers deleted in source, size={}", (Object)this.name, (Object)arrayList.size());
            try {
                this.advanceCursorsIfNecessary(arrayList);
            }
            catch (ManagedLedgerException.LedgerNotExistException e) {
                log.info("[{}] First non deleted Ledger is not found, advanceCursors fails", (Object)this.name);
            }
            this.doDeleteLedgers(arrayList);
        }
    }

    @Override
    public synchronized void asyncClose(AsyncCallbacks.CloseCallback callback, Object ctx) {
        this.store.unwatchManagedLedgerInfo(this.sourceMLName);
        super.asyncClose(callback, ctx);
    }

    @Override
    protected synchronized void updateLedgersIdsComplete(LedgerHandle originalCurrentLedger) {
        OpAddEntry op;
        Position position;
        STATE_UPDATER.set(this, ManagedLedgerImpl.State.LedgerOpened);
        this.updateLastLedgerCreatedTimeAndScheduleRolloverTask();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Resending {} pending messages", (Object)this.name, (Object)this.pendingAddEntries.size());
        }
        this.createNewOpAddEntryForNewLedger();
        Iterator iterator = this.pendingAddEntries.iterator();
        while (iterator.hasNext() && (position = (Position)(op = (OpAddEntry)iterator.next()).getCtx()).getLedgerId() <= this.currentLedger.getId()) {
            if (position.getLedgerId() == this.currentLedger.getId()) {
                op.setLedger(this.currentLedger);
            } else {
                op.setLedger(null);
            }
            this.currentLedgerEntries = position.getEntryId();
            this.currentLedgerSize += (long)op.data.readableBytes();
            op.initiateShadowWrite();
        }
    }

    @Override
    protected void updateLastLedgerCreatedTimeAndScheduleRolloverTask() {
        this.lastLedgerCreatedTimestamp = this.clock.millis();
    }

    @Override
    boolean shouldCacheAddedEntry() {
        return false;
    }
}

