/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.net;

import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import javax.net.ssl.SSLEngine;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.DataObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.SSLEngineOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.tls.DefaultSslContextFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.tls.SslContextFactory;

@DataObject
public class JdkSSLEngineOptions
extends SSLEngineOptions {
    private static Boolean jdkAlpnAvailable;
    private boolean pooledHeapBuffers = false;

    public static synchronized boolean isAlpnAvailable() {
        if (jdkAlpnAvailable == null) {
            boolean available = false;
            try {
                SSLEngine.class.getDeclaredMethod("getApplicationProtocol", new Class[0]);
                available = true;
            }
            catch (Exception ignore1) {
                try {
                    JdkSSLEngineOptions.class.getClassLoader().loadClass("sun.security.ssl.ALPNExtension");
                    available = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                jdkAlpnAvailable = available;
            }
        }
        return jdkAlpnAvailable;
    }

    public JdkSSLEngineOptions() {
    }

    public JdkSSLEngineOptions(JsonObject json) {
        super(json);
        this.pooledHeapBuffers = json.getBoolean("pooledHeapBuffers", false);
    }

    public JdkSSLEngineOptions(JdkSSLEngineOptions that) {
        super(that);
        this.pooledHeapBuffers = that.pooledHeapBuffers;
    }

    public JdkSSLEngineOptions setPooledHeapBuffers(boolean pooledHeapBuffers) {
        this.pooledHeapBuffers = pooledHeapBuffers;
        return this;
    }

    public boolean isPooledHeapBuffers() {
        return this.pooledHeapBuffers;
    }

    @Override
    public JdkSSLEngineOptions setUseWorkerThread(boolean useWorkerThread) {
        return (JdkSSLEngineOptions)super.setUseWorkerThread(useWorkerThread);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("pooledHeapBuffers", this.pooledHeapBuffers);
        return jsonObject;
    }

    @Override
    public JdkSSLEngineOptions copy() {
        return new JdkSSLEngineOptions(this);
    }

    @Override
    public SslContextFactory sslContextFactory() {
        return new DefaultSslContextFactory(SslProvider.JDK, false);
    }
}

