/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class TransactionMetadataStoreState {
    private static final AtomicReferenceFieldUpdater<TransactionMetadataStoreState, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(TransactionMetadataStoreState.class, State.class, "state");
    private volatile State state = null;

    public TransactionMetadataStoreState(State state) {
        STATE_UPDATER.set(this, state);
    }

    protected boolean changeToReadyState() {
        return STATE_UPDATER.compareAndSet(this, State.Initializing, State.Ready);
    }

    protected boolean changeToInitializingState() {
        return STATE_UPDATER.compareAndSet(this, State.None, State.Initializing);
    }

    protected boolean changeToClosingState() {
        return STATE_UPDATER.compareAndSet(this, State.Ready, State.Closing) || STATE_UPDATER.compareAndSet(this, State.None, State.Closing) || STATE_UPDATER.compareAndSet(this, State.Initializing, State.Closing);
    }

    protected boolean changeToCloseState() {
        return STATE_UPDATER.compareAndSet(this, State.Closing, State.Close);
    }

    protected boolean checkIfReady() {
        return STATE_UPDATER.get(this) == State.Ready;
    }

    public State getState() {
        return STATE_UPDATER.get(this);
    }

    public static enum State {
        None,
        Initializing,
        Ready,
        Closing,
        Close;

    }
}

