/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.filter;

import com.github.zafarkhaja.semver.Version;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.BrokerFilterBadVersionException;
import org.apache.pulsar.broker.loadbalance.extensions.LoadManagerContext;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.loadbalance.extensions.filter.BrokerFilter;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerVersionFilter
implements BrokerFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BrokerVersionFilter.class);
    public static final String FILTER_NAME = "broker_version_filter";

    @Override
    public CompletableFuture<Map<String, BrokerLookupData>> filterAsync(Map<String, BrokerLookupData> brokers, ServiceUnitId serviceUnit, LoadManagerContext context) {
        Version latestVersion;
        ServiceConfiguration conf = context.brokerConfiguration();
        if (!conf.isPreferLaterVersions() || brokers.isEmpty()) {
            return CompletableFuture.completedFuture(brokers);
        }
        try {
            latestVersion = this.getLatestVersionNumber(brokers);
            if (log.isDebugEnabled()) {
                log.debug("Latest broker version found was [{}]", (Object)latestVersion);
            }
        }
        catch (Exception ex) {
            log.warn("Disabling PreferLaterVersions feature; reason: " + ex.getMessage());
            return FutureUtil.failedFuture((Throwable)new BrokerFilterBadVersionException("Cannot determine newest broker version: " + ex.getMessage()));
        }
        int numBrokersLatestVersion = 0;
        int numBrokersOlderVersion = 0;
        Iterator<Map.Entry<String, BrokerLookupData>> brokerIterator = brokers.entrySet().iterator();
        while (brokerIterator.hasNext()) {
            Map.Entry<String, BrokerLookupData> next = brokerIterator.next();
            String brokerId = next.getKey();
            String version = next.getValue().brokerVersion();
            Version brokerVersionVersion = Version.valueOf((String)version);
            if (brokerVersionVersion.equals((Object)latestVersion)) {
                log.debug("Broker [{}] is running the latest version ([{}])", (Object)brokerId, (Object)version);
                ++numBrokersLatestVersion;
                continue;
            }
            log.info("Broker [{}] is running an older version ([{}]); latest version is [{}]", new Object[]{brokerId, version, latestVersion});
            ++numBrokersOlderVersion;
            brokerIterator.remove();
        }
        if (numBrokersOlderVersion == 0) {
            log.info("All {} brokers are running the latest version [{}]", (Object)numBrokersLatestVersion, (Object)latestVersion);
        }
        return CompletableFuture.completedFuture(brokers);
    }

    public Version getLatestVersionNumber(Map<String, BrokerLookupData> brokerMap) throws BrokerFilterBadVersionException {
        if (brokerMap.size() == 0) {
            throw new BrokerFilterBadVersionException("Unable to determine latest version since broker version map was empty");
        }
        Version latestVersion = null;
        for (Map.Entry<String, BrokerLookupData> entry : brokerMap.entrySet()) {
            Version brokerVersionVersion;
            String brokerId = entry.getKey();
            String version = entry.getValue().brokerVersion();
            if (null == version || version.length() == 0) {
                log.warn("No version string in lookup data for broker [{}]; disabling PreferLaterVersions feature", (Object)brokerId);
                throw new BrokerFilterBadVersionException("No version string in lookup data for broker \"" + brokerId + "\"");
            }
            try {
                brokerVersionVersion = Version.valueOf((String)version);
            }
            catch (Exception x) {
                log.warn("Invalid version string in lookup data for broker [{}]: [{}]; disabling PreferLaterVersions feature", (Object)brokerId, (Object)version);
                throw new BrokerFilterBadVersionException("Invalid version string in lookup data for broker \"" + brokerId + "\": \"" + version + "\")");
            }
            if (latestVersion == null) {
                latestVersion = brokerVersionVersion;
                continue;
            }
            if (Version.BUILD_AWARE_ORDER.compare(latestVersion, brokerVersionVersion) >= 0) continue;
            latestVersion = brokerVersionVersion;
        }
        return latestVersion;
    }

    @Override
    public String name() {
        return FILTER_NAME;
    }
}

