/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.collect.Range;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import lombok.Generated;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.ReadOnlyCursor;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.impl.ReadOnlyCursorImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.pulsar.metadata.api.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyManagedLedgerImpl
extends ManagedLedgerImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyManagedLedgerImpl.class);

    public ReadOnlyManagedLedgerImpl(ManagedLedgerFactoryImpl factory, BookKeeper bookKeeper, MetaStore store, ManagedLedgerConfig config, OrderedScheduler scheduledExecutor, String name) {
        super(factory, bookKeeper, store, config, scheduledExecutor, name);
    }

    public CompletableFuture<Void> initialize() {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.store.getManagedLedgerInfo(this.name, false, new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            @Override
            public void operationComplete(MLDataFormats.ManagedLedgerInfo mlInfo, Stat stat) {
                ReadOnlyManagedLedgerImpl.this.state = ManagedLedgerImpl.State.LedgerOpened;
                for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ls : mlInfo.getLedgerInfoList()) {
                    ReadOnlyManagedLedgerImpl.this.ledgers.put(ls.getLedgerId(), ls);
                }
                if (mlInfo.getPropertiesCount() > 0) {
                    for (int i = 0; i < mlInfo.getPropertiesCount(); ++i) {
                        MLDataFormats.KeyValue property = mlInfo.getProperties(i);
                        ReadOnlyManagedLedgerImpl.this.propertiesMap.put(property.getKey(), property.getValue());
                    }
                }
                if (ReadOnlyManagedLedgerImpl.this.ledgers.size() > 0 && ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ReadOnlyManagedLedgerImpl.this.ledgers.lastEntry().getValue()).getEntries() == 0L) {
                    long lastLedgerId = (Long)ReadOnlyManagedLedgerImpl.this.ledgers.lastKey();
                    ((CompletableFuture)ReadOnlyManagedLedgerImpl.this.bookKeeper.newOpenLedgerOp().withRecovery(false).withLedgerId(lastLedgerId).withDigestType(ReadOnlyManagedLedgerImpl.this.config.getDigestType()).withPassword(ReadOnlyManagedLedgerImpl.this.config.getPassword()).execute().thenAccept(readHandle -> ((CompletableFuture)readHandle.readLastAddConfirmedAsync().thenAccept(lastAddConfirmed -> {
                        MLDataFormats.ManagedLedgerInfo.LedgerInfo info = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(lastLedgerId).setEntries(lastAddConfirmed + 1L).setSize(readHandle.getLength()).setTimestamp(ReadOnlyManagedLedgerImpl.this.clock.millis()).build();
                        ReadOnlyManagedLedgerImpl.this.ledgers.put(lastLedgerId, info);
                        future.complete(null);
                    })).exceptionally(ex -> {
                        if (ex instanceof CompletionException && ex.getCause() instanceof IllegalArgumentException) {
                            MLDataFormats.ManagedLedgerInfo.LedgerInfo info = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(lastLedgerId).setEntries(0L).setSize(0L).setTimestamp(ReadOnlyManagedLedgerImpl.this.clock.millis()).build();
                            ReadOnlyManagedLedgerImpl.this.ledgers.put(lastLedgerId, info);
                            future.complete(null);
                        } else {
                            future.completeExceptionally(new ManagedLedgerException((Throwable)ex));
                        }
                        return null;
                    }))).exceptionally(ex -> {
                        if (ex instanceof CompletionException && ex.getCause() instanceof ArrayIndexOutOfBoundsException) {
                            MLDataFormats.ManagedLedgerInfo.LedgerInfo info = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(lastLedgerId).setEntries(0L).setSize(0L).setTimestamp(ReadOnlyManagedLedgerImpl.this.clock.millis()).build();
                            ReadOnlyManagedLedgerImpl.this.ledgers.put(lastLedgerId, info);
                            future.complete(null);
                        } else {
                            future.completeExceptionally(new ManagedLedgerException((Throwable)ex));
                        }
                        return null;
                    });
                } else {
                    future.complete(null);
                }
            }

            @Override
            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                if (e instanceof ManagedLedgerException.MetadataNotFoundException) {
                    future.completeExceptionally(new ManagedLedgerException.ManagedLedgerNotFoundException(e));
                } else {
                    future.completeExceptionally(new ManagedLedgerException(e));
                }
            }
        });
        return future;
    }

    public ReadOnlyCursor createReadOnlyCursor(Position startPosition) {
        if (this.ledgers.isEmpty()) {
            this.lastConfirmedEntry = PositionFactory.EARLIEST;
        } else if (((MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.lastEntry().getValue()).getEntries() > 0L) {
            this.lastConfirmedEntry = PositionFactory.create((Long)this.ledgers.lastKey(), ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.lastEntry().getValue()).getEntries() - 1L);
        } else if (this.ledgers.size() > 1) {
            long lastLedgerId = (Long)this.ledgers.lastKey();
            MLDataFormats.ManagedLedgerInfo.LedgerInfo li = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledgers.headMap(lastLedgerId, false).lastEntry().getValue();
            this.lastConfirmedEntry = PositionFactory.create(li.getLedgerId(), li.getEntries() - 1L);
        } else {
            this.lastConfirmedEntry = PositionFactory.EARLIEST;
        }
        return new ReadOnlyCursorImpl(this.bookKeeper, this, startPosition, "read-only-cursor");
    }

    @Override
    public void asyncReadEntry(Position position, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        ((CompletableFuture)this.getLedgerHandle(position.getLedgerId()).thenAccept(ledger -> this.asyncReadEntry((ReadHandle)ledger, position, callback, ctx))).exceptionally(ex -> {
            log.error("[{}] Error opening ledger for reading at position {} - {}. Op: {}", new Object[]{this.name, position, ex.getMessage(), callback});
            callback.readEntryFailed(ManagedLedgerException.getManagedLedgerException(ex.getCause()), ctx);
            return null;
        });
    }

    @Override
    public long getNumberOfEntries() {
        return this.getNumberOfEntries((Range<Position>)Range.openClosed((Comparable)PositionFactory.EARLIEST, (Comparable)this.getLastPosition()));
    }

    @Override
    protected boolean isReadOnly() {
        return true;
    }
}

