/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.rpc;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.AutoValue_RpcServerMetrics_State;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcMetricsAdvice;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RpcServerMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> RPC_SERVER_REQUEST_METRICS_STATE = ContextKey.named((String)"rpc-server-request-metrics-state");
    private static final Logger logger = Logger.getLogger(RpcServerMetrics.class.getName());
    private final DoubleHistogram serverDurationHistogram;

    private RpcServerMetrics(Meter meter) {
        DoubleHistogramBuilder durationBuilder = meter.histogramBuilder("rpc.server.duration").setDescription("The duration of an inbound RPC invocation").setUnit("ms");
        RpcMetricsAdvice.applyServerDurationAdvice(durationBuilder);
        this.serverDurationHistogram = durationBuilder.build();
    }

    public static OperationMetrics get() {
        return RpcServerMetrics::new;
    }

    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(RPC_SERVER_REQUEST_METRICS_STATE, (Object)new AutoValue_RpcServerMetrics_State(startAttributes, startNanos));
    }

    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = (State)context.get(RPC_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record RPC request metrics.", context);
            return;
        }
        this.serverDurationHistogram.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, state.startAttributes().toBuilder().putAll(endAttributes).build(), context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

