/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.ext.javatime.ser.JSR310FormattedSerializerBase;
import tools.jackson.databind.ext.javatime.util.DecimalUtils;
import tools.jackson.databind.ext.javatime.util.DurationUnitConverter;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonValueFormat;

public class DurationSerializer
extends JSR310FormattedSerializerBase<Duration> {
    public static final DurationSerializer INSTANCE = new DurationSerializer();
    private DurationUnitConverter _durationUnitConverter;

    protected DurationSerializer() {
        super(Duration.class);
    }

    protected DurationSerializer(DurationSerializer base, DateTimeFormatter dtf, Boolean useTimestamp) {
        super(base, dtf, useTimestamp, null, null);
    }

    protected DurationSerializer(DurationSerializer base, DateTimeFormatter dtf, Boolean useTimestamp, Boolean useNanoseconds) {
        super(base, dtf, useTimestamp, useNanoseconds, null);
    }

    protected DurationSerializer(DurationSerializer base, DurationUnitConverter converter) {
        super(base, base._formatter, base._useTimestamp, base._useNanoseconds, base._shape);
        this._durationUnitConverter = converter;
    }

    protected DurationSerializer withFormat(DateTimeFormatter dtf, Boolean useTimestamp, JsonFormat.Shape shape) {
        return new DurationSerializer(this, dtf, useTimestamp);
    }

    protected DurationSerializer withConverter(DurationUnitConverter converter) {
        return new DurationSerializer(this, converter);
    }

    @Override
    protected DateTimeFeature getTimestampsFeature() {
        return DateTimeFeature.WRITE_DURATIONS_AS_TIMESTAMPS;
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        DurationSerializer ser = (DurationSerializer)super.createContextual(ctxt, property);
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        if (format != null && format.hasPattern()) {
            String pattern = format.getPattern();
            DurationUnitConverter p = DurationUnitConverter.from(pattern);
            if (p == null) {
                ctxt.reportBadDefinition(this.handledType(), String.format("Bad 'pattern' definition (\"%s\") for `Duration`: expected one of [%s]", pattern, DurationUnitConverter.descForAllowed()));
            }
            ser = ser.withConverter(p);
        }
        return ser;
    }

    @Override
    public void serialize(Duration duration, JsonGenerator generator, SerializationContext ctxt) throws JacksonException {
        if (this.useTimestamp(ctxt)) {
            if (this._durationUnitConverter != null) {
                generator.writeNumber(this._durationUnitConverter.convert(duration));
            } else if (this.useNanoseconds(ctxt)) {
                generator.writeNumber(this._toNanos(duration));
            } else {
                generator.writeNumber(duration.toMillis());
            }
        } else {
            generator.writeString(duration.toString());
        }
    }

    private BigDecimal _toNanos(Duration duration) {
        BigDecimal bd;
        if (duration.isNegative()) {
            duration = duration.abs();
            bd = DecimalUtils.toBigDecimal(duration.getSeconds(), duration.getNano()).negate();
        } else {
            bd = DecimalUtils.toBigDecimal(duration.getSeconds(), duration.getNano());
        }
        return bd;
    }

    @Override
    protected void _acceptTimestampVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.LONG);
            SerializationContext ctxt = visitor.getContext();
            if (ctxt == null || !this.useNanoseconds(ctxt)) {
                v2.format(JsonValueFormat.UTC_MILLISEC);
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializationContext ctxt) {
        if (this.useTimestamp(ctxt)) {
            if (this.useNanoseconds(ctxt)) {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            return JsonToken.VALUE_NUMBER_INT;
        }
        return JsonToken.VALUE_STRING;
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean writeZoneId, Boolean writeNanoseconds) {
        return new DurationSerializer(this, this._formatter, this._useTimestamp, writeNanoseconds);
    }

    @Override
    protected DateTimeFormatter _useDateTimeFormatter(SerializationContext ctxt, JsonFormat.Value format) {
        return null;
    }
}

