/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import org.apache.qpid.server.SystemLauncherListener;
import org.apache.qpid.server.logging.logback.Logback1027WorkaroundTurboFilter;
import org.apache.qpid.server.logging.logback.QpidLoggerTurboFilter;
import org.apache.qpid.server.logging.logback.StartupAppender;
import org.apache.qpid.server.model.SystemConfig;
import org.slf4j.LoggerFactory;

public class LogbackLoggingSystemLauncherListener
implements SystemLauncherListener {
    private StartupAppender _startupAppender;
    private Logger _logger;
    private Logback1027WorkaroundTurboFilter _logback1027WorkaroundTurboFilter;

    public void beforeStartup() {
        this._logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        if (!this._logger.iteratorForAppenders().hasNext()) {
            this._logger.setLevel(Level.TRACE);
            this._logger.setAdditive(true);
        }
        LoggerContext loggerContext = this._logger.getLoggerContext();
        this._logback1027WorkaroundTurboFilter = new Logback1027WorkaroundTurboFilter();
        loggerContext.addTurboFilter((TurboFilter)this._logback1027WorkaroundTurboFilter);
        this._startupAppender = new StartupAppender();
        this._startupAppender.setContext((Context)loggerContext);
        this._startupAppender.start();
        this._logger.addAppender((Appender)this._startupAppender);
    }

    public void errorOnStartup(RuntimeException e) {
        this._startupAppender.logToConsole();
    }

    public void afterStartup() {
        this._logger.detachAppender((Appender)this._startupAppender);
        this._startupAppender.stop();
    }

    public void onContainerResolve(SystemConfig<?> systemConfig) {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        StartupAppender startupAppender = (StartupAppender)rootLogger.getAppender(StartupAppender.class.getName());
        if (startupAppender != null) {
            rootLogger.detachAppender((Appender)startupAppender);
            startupAppender.stop();
        }
    }

    public void onContainerClose(SystemConfig<?> systemConfig) {
        QpidLoggerTurboFilter.uninstallFromRootContext();
        this._logger.getLoggerContext().getTurboFilterList().remove((Object)this._logback1027WorkaroundTurboFilter);
    }

    public void onShutdown(int exitCode) {
    }

    public void exceptionOnShutdown(Exception e) {
    }
}

