/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.logging.messages.PortMessages;
import org.apache.qpid.server.logging.subjects.PortLogSubject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.plugin.ProtocolEngineCreator;
import org.apache.qpid.server.security.ManagedPeerCertificateTrustStore;
import org.apache.qpid.server.transport.AbstractAMQPConnection;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.ByteBufferSender;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.apache.qpid.server.transport.SchedulingDelayNotificationListener;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.transport.network.Ticker;
import org.apache.qpid.server.transport.util.Functions;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiVersionProtocolEngine
implements ProtocolEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiVersionProtocolEngine.class);
    private static final int MINIMUM_REQUIRED_HEADER_BYTES = 8;
    private final long _id;
    private final AmqpPort<?> _port;
    private Transport _transport;
    private final ProtocolEngineCreator[] _creators;
    private final Runnable _onCloseTask;
    private final Set<Protocol> _supported;
    private String _fqdn;
    private final Broker<?> _broker;
    private ServerNetworkConnection _network;
    private ByteBufferSender _sender;
    private final Protocol _defaultSupportedReply;
    private volatile ProtocolEngine _delegate = new SelfDelegateProtocolEngine();
    private volatile Thread _ioThread;
    private final AtomicReference<Action<ProtocolEngine>> _workListener = new AtomicReference();
    private final AggregateTicker _aggregateTicker = new AggregateTicker();

    public MultiVersionProtocolEngine(Broker<?> broker, Set<Protocol> supported, Protocol defaultSupportedReply, AmqpPort<?> port, Transport transport, long id, ProtocolEngineCreator[] creators, Runnable onCloseTask) {
        this._id = id;
        this._broker = broker;
        this._supported = supported;
        this._defaultSupportedReply = defaultSupportedReply;
        this._port = port;
        this._transport = transport;
        this._creators = creators;
        this._onCloseTask = onCloseTask;
    }

    @Override
    public void closed() {
        LOGGER.debug("Closed");
        try {
            this._delegate.closed();
        }
        finally {
            if (this._onCloseTask != null) {
                this._onCloseTask.run();
            }
        }
    }

    @Override
    public void writerIdle() {
        this._delegate.writerIdle();
    }

    @Override
    public void readerIdle() {
        this._delegate.readerIdle();
    }

    @Override
    public void encryptedTransport() {
        this._delegate.encryptedTransport();
    }

    @Override
    public void received(QpidByteBuffer msg) {
        this._delegate.received(msg);
    }

    @Override
    public void setIOThread(Thread ioThread) {
        this._ioThread = ioThread;
        this._delegate.setIOThread(ioThread);
    }

    public long getConnectionId() {
        return this._id;
    }

    @Override
    public Subject getSubject() {
        return this._delegate.getSubject();
    }

    @Override
    public boolean isTransportBlockedForWriting() {
        return this._delegate.isTransportBlockedForWriting();
    }

    @Override
    public void setTransportBlockedForWriting(boolean blocked) {
        this._delegate.setTransportBlockedForWriting(blocked);
    }

    public void setNetworkConnection(ServerNetworkConnection network) {
        this._network = network;
        SocketAddress address = this._network.getLocalAddress();
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported socket address class: " + String.valueOf(address));
        }
        this._fqdn = ((InetSocketAddress)address).getHostName();
        this._sender = network.getSender();
        SlowProtocolHeaderTicker ticker = new SlowProtocolHeaderTicker(this._port.getProtocolHandshakeTimeout(), System.currentTimeMillis());
        this._aggregateTicker.addTicker(ticker);
        this._network.addSchedulingDelayNotificationListeners(this._aggregateTicker);
    }

    @Override
    public long getLastReadTime() {
        return this._delegate.getLastReadTime();
    }

    @Override
    public long getLastWriteTime() {
        return this._delegate.getLastWriteTime();
    }

    @Override
    public Iterator<Runnable> processPendingIterator() {
        return this._delegate.processPendingIterator();
    }

    @Override
    public boolean hasWork() {
        return this._delegate.hasWork();
    }

    @Override
    public void notifyWork() {
        this._delegate.notifyWork();
    }

    @Override
    public void setWorkListener(Action<ProtocolEngine> listener) {
        this._workListener.set(listener);
        this._delegate.setWorkListener(listener);
    }

    @Override
    public void clearWork() {
        this._delegate.clearWork();
    }

    @Override
    public AggregateTicker getAggregateTicker() {
        return this._aggregateTicker;
    }

    public boolean isProtocolEstablished() {
        return this._delegate instanceof AbstractAMQPConnection;
    }

    private class SelfDelegateProtocolEngine
    implements ProtocolEngine {
        private final QpidByteBuffer _header = QpidByteBuffer.allocate(8);
        private long _lastReadTime = System.currentTimeMillis();
        private final AtomicBoolean _hasWork = new AtomicBoolean();

        private SelfDelegateProtocolEngine() {
        }

        @Override
        public Iterator<Runnable> processPendingIterator() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean hasWork() {
            return this._hasWork.get();
        }

        @Override
        public void notifyWork() {
            this._hasWork.set(true);
        }

        @Override
        public void setWorkListener(Action<ProtocolEngine> listener) {
        }

        @Override
        public AggregateTicker getAggregateTicker() {
            return MultiVersionProtocolEngine.this._aggregateTicker;
        }

        @Override
        public void clearWork() {
            this._hasWork.set(false);
        }

        @Override
        public void received(QpidByteBuffer msg) {
            this._lastReadTime = System.currentTimeMillis();
            try (QpidByteBuffer msgheader = msg.slice();){
                if (this._header.remaining() > msgheader.limit()) {
                    return;
                }
                msgheader.limit(this._header.remaining());
                msg.position(msg.position() + this._header.remaining());
                this._header.put(msgheader);
            }
            if (!this._header.hasRemaining()) {
                this._header.flip();
                byte[] headerBytes = new byte[8];
                this._header.get(headerBytes);
                ProtocolEngine newDelegate = null;
                byte[] supportedReplyBytes = null;
                byte[] defaultSupportedReplyBytes = null;
                Protocol supportedReplyVersion = null;
                for (int i = 0; newDelegate == null && i < MultiVersionProtocolEngine.this._creators.length; ++i) {
                    ProtocolEngineCreator creator2 = MultiVersionProtocolEngine.this._creators[i];
                    if (MultiVersionProtocolEngine.this._supported.contains((Object)creator2.getVersion())) {
                        supportedReplyBytes = creator2.getHeaderIdentifier();
                        supportedReplyVersion = creator2.getVersion();
                        byte[] compareBytes = creator2.getHeaderIdentifier();
                        boolean equal = true;
                        for (int j = 0; equal && j < compareBytes.length; ++j) {
                            equal = headerBytes[j] == compareBytes[j];
                        }
                        if (equal && (newDelegate = creator2.newProtocolEngine(MultiVersionProtocolEngine.this._broker, MultiVersionProtocolEngine.this._network, MultiVersionProtocolEngine.this._port, MultiVersionProtocolEngine.this._transport, MultiVersionProtocolEngine.this._id, MultiVersionProtocolEngine.this._aggregateTicker)) == null && creator2.getSuggestedAlternativeHeader() != null) {
                            defaultSupportedReplyBytes = creator2.getSuggestedAlternativeHeader();
                        }
                    }
                    if (defaultSupportedReplyBytes != null || MultiVersionProtocolEngine.this._defaultSupportedReply == null || creator2.getVersion() != MultiVersionProtocolEngine.this._defaultSupportedReply) continue;
                    defaultSupportedReplyBytes = creator2.getHeaderIdentifier();
                }
                if (newDelegate == null) {
                    if (MultiVersionProtocolEngine.this._defaultSupportedReply != null && MultiVersionProtocolEngine.this._defaultSupportedReply != supportedReplyVersion) {
                        LOGGER.debug("Default reply to unsupported protocol version was configured, changing reply from {} to {}", supportedReplyVersion, (Object)MultiVersionProtocolEngine.this._defaultSupportedReply);
                        supportedReplyBytes = defaultSupportedReplyBytes;
                        supportedReplyVersion = MultiVersionProtocolEngine.this._defaultSupportedReply;
                    }
                    MultiVersionProtocolEngine.this._broker.getEventLogger().message(new PortLogSubject(MultiVersionProtocolEngine.this._port), PortMessages.UNSUPPORTED_PROTOCOL_HEADER(Functions.str(headerBytes), String.valueOf(supportedReplyVersion)));
                    if (supportedReplyBytes == null) {
                        ProtocolEngineCreator protocol = Arrays.stream(MultiVersionProtocolEngine.this._creators).filter(creator -> creator.getVersion().isAMQP() && MultiVersionProtocolEngine.this._supported.contains((Object)creator.getVersion())).max(Comparator.comparingInt(creator -> creator.getVersion().ordinal())).orElseThrow(() -> new ServerScopedRuntimeException("All AMQP protocols are disabled"));
                        supportedReplyBytes = protocol.getHeaderIdentifier();
                    }
                    try (QpidByteBuffer supportedReplyBuf = QpidByteBuffer.allocateDirect(supportedReplyBytes.length);){
                        supportedReplyBuf.put(supportedReplyBytes);
                        supportedReplyBuf.flip();
                        MultiVersionProtocolEngine.this._sender.send(supportedReplyBuf);
                    }
                    MultiVersionProtocolEngine.this._sender.flush();
                    MultiVersionProtocolEngine.this._delegate = new ClosedDelegateProtocolEngine();
                    this._header.dispose();
                    MultiVersionProtocolEngine.this._network.close();
                } else {
                    boolean hasWork = MultiVersionProtocolEngine.this._delegate.hasWork();
                    if (hasWork) {
                        newDelegate.notifyWork();
                    }
                    MultiVersionProtocolEngine.this._delegate = newDelegate;
                    MultiVersionProtocolEngine.this._delegate.setIOThread(MultiVersionProtocolEngine.this._ioThread);
                    MultiVersionProtocolEngine.this._delegate.setWorkListener(MultiVersionProtocolEngine.this._workListener.get());
                    this._header.flip();
                    MultiVersionProtocolEngine.this._delegate.received(this._header);
                    this._header.dispose();
                    Certificate peerCertificate = MultiVersionProtocolEngine.this._network.getPeerCertificate();
                    if (peerCertificate != null && MultiVersionProtocolEngine.this._port.getClientCertRecorder() != null) {
                        ((ManagedPeerCertificateTrustStore)MultiVersionProtocolEngine.this._port.getClientCertRecorder()).addCertificate(peerCertificate);
                    }
                    if (msg.hasRemaining()) {
                        MultiVersionProtocolEngine.this._delegate.received(msg);
                    }
                }
            }
        }

        @Override
        public void setIOThread(Thread ioThread) {
        }

        @Override
        public Subject getSubject() {
            return MultiVersionProtocolEngine.this._delegate.getSubject();
        }

        @Override
        public boolean isTransportBlockedForWriting() {
            return false;
        }

        @Override
        public void setTransportBlockedForWriting(boolean blocked) {
        }

        @Override
        public void closed() {
            try {
                MultiVersionProtocolEngine.this._delegate = new ClosedDelegateProtocolEngine();
                LOGGER.debug("Connection from {} was closed before any protocol version was established.", (Object)MultiVersionProtocolEngine.this._network.getRemoteAddress());
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    MultiVersionProtocolEngine.this._network.close();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void writerIdle() {
        }

        @Override
        public void readerIdle() {
        }

        @Override
        public void encryptedTransport() {
            if (MultiVersionProtocolEngine.this._transport == Transport.TCP) {
                MultiVersionProtocolEngine.this._transport = Transport.SSL;
            }
        }

        @Override
        public long getLastReadTime() {
            return this._lastReadTime;
        }

        @Override
        public long getLastWriteTime() {
            return 0L;
        }
    }

    class SlowProtocolHeaderTicker
    implements Ticker,
    SchedulingDelayNotificationListener {
        private final long _allowedTime;
        private final long _createdTime;
        private volatile long _accumulatedSchedulingDelay;

        public SlowProtocolHeaderTicker(long allowedTime, long createdTime) {
            this._allowedTime = allowedTime;
            this._createdTime = createdTime;
        }

        @Override
        public int getTimeToNextTick(long currentTime) {
            return (int)(this._createdTime + this._allowedTime + this._accumulatedSchedulingDelay - currentTime);
        }

        @Override
        public int tick(long currentTime) {
            int nextTick = this.getTimeToNextTick(currentTime);
            if (nextTick <= 0) {
                if (MultiVersionProtocolEngine.this.isProtocolEstablished()) {
                    MultiVersionProtocolEngine.this._aggregateTicker.removeTicker(this);
                    MultiVersionProtocolEngine.this._network.removeSchedulingDelayNotificationListeners(this);
                } else {
                    LOGGER.warn("Connection has taken more than {} ms to send complete protocol header.  Closing as possible DoS.", (Object)this._allowedTime);
                    MultiVersionProtocolEngine.this._broker.getEventLogger().message(ConnectionMessages.IDLE_CLOSE("Protocol header not received within timeout period", true));
                    MultiVersionProtocolEngine.this._network.close();
                }
            }
            return nextTick;
        }

        @Override
        public void notifySchedulingDelay(long schedulingDelay) {
            if (schedulingDelay > 0L) {
                this._accumulatedSchedulingDelay += schedulingDelay;
            }
        }
    }

    private class ClosedDelegateProtocolEngine
    implements ProtocolEngine {
        private ClosedDelegateProtocolEngine() {
        }

        @Override
        public Iterator<Runnable> processPendingIterator() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean hasWork() {
            return false;
        }

        @Override
        public void notifyWork() {
        }

        @Override
        public void setWorkListener(Action<ProtocolEngine> listener) {
        }

        @Override
        public void clearWork() {
        }

        @Override
        public void received(QpidByteBuffer msg) {
            LOGGER.debug("Error processing incoming data, could not negotiate a common protocol");
            msg.position(msg.limit());
        }

        @Override
        public void setIOThread(Thread ioThread) {
        }

        @Override
        public void closed() {
        }

        @Override
        public void writerIdle() {
        }

        @Override
        public void readerIdle() {
        }

        @Override
        public void encryptedTransport() {
        }

        @Override
        public long getLastReadTime() {
            return 0L;
        }

        @Override
        public long getLastWriteTime() {
            return 0L;
        }

        @Override
        public Subject getSubject() {
            return new Subject();
        }

        @Override
        public boolean isTransportBlockedForWriting() {
            return false;
        }

        @Override
        public void setTransportBlockedForWriting(boolean blocked) {
        }

        @Override
        public AggregateTicker getAggregateTicker() {
            return MultiVersionProtocolEngine.this._aggregateTicker;
        }
    }
}

