/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.security.AccessController;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.qpid.server.logging.logback.LogBackLogInclusionRule;
import org.apache.qpid.server.model.BrokerLogger;
import org.apache.qpid.server.virtualhost.VirtualHostPrincipal;

public class VirtualHostLogEventExcludingFilter
extends Filter<ILoggingEvent>
implements LogBackLogInclusionRule {
    private final BrokerLogger<?> _brokerLogger;

    public VirtualHostLogEventExcludingFilter(BrokerLogger<?> brokerLogger) {
        this._brokerLogger = brokerLogger;
    }

    @Override
    public Filter<ILoggingEvent> asFilter() {
        return this;
    }

    public String getName() {
        return "$" + this.getClass().getName();
    }

    public FilterReply decide(ILoggingEvent event) {
        if (!this._brokerLogger.isVirtualHostLogEventExcluded() || !this.subjectContainsVirtualHostPrincipal()) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    private boolean subjectContainsVirtualHostPrincipal() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null) {
            Set<Principal> principals = subject.getPrincipals();
            for (Principal principal : principals) {
                if (!(principal instanceof VirtualHostPrincipal)) continue;
                return true;
            }
        }
        return false;
    }
}

