/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import jakarta.jms.JMSException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.TextMessage;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.facade.JmsTextMessageFacade;

public class JmsTextMessage
extends JmsMessage
implements TextMessage {
    private final JmsTextMessageFacade facade;

    public JmsTextMessage(JmsTextMessageFacade facade) {
        super(facade);
        this.facade = facade;
    }

    @Override
    public JmsTextMessage copy() throws JMSException {
        JmsTextMessage other = new JmsTextMessage(this.facade.copy());
        other.copy(this);
        return other;
    }

    private void copy(JmsTextMessage other) throws JMSException {
        super.copy(other);
    }

    public void setText(String text) throws JMSException, MessageNotWriteableException {
        this.checkReadOnlyBody();
        this.facade.setText(text);
    }

    public String getText() throws JMSException {
        return this.facade.getText();
    }

    @Override
    public String toString() {
        return "JmsTextMessage { " + this.facade.toString() + " }";
    }

    @Override
    public boolean isBodyAssignableTo(Class target) throws JMSException {
        return this.facade.hasBody() ? target.isAssignableFrom(String.class) : true;
    }

    @Override
    protected <T> T doGetBody(Class<T> asType) throws JMSException {
        return (T)this.getText();
    }
}

