/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.messaging;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Data;

public final class DataTypeEncoder
extends AbstractDescribedTypeEncoder<Data> {
    private static final byte[] DATA_PREAMBLE = new byte[]{0, 83, Data.DESCRIPTOR_CODE.byteValue()};

    @Override
    public Class<Data> getTypeClass() {
        return Data.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Data.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Data.DESCRIPTOR_SYMBOL;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, Data value) {
        buffer.writeBytes(DATA_PREAMBLE);
        if (value.hasBinary()) {
            int dataLength = value.getDataLength();
            if (dataLength > 255) {
                buffer.ensureWritable(dataLength + 8);
                buffer.writeByte((byte)-80);
                buffer.writeInt(dataLength);
            } else {
                buffer.ensureWritable(dataLength + 2);
                buffer.writeByte((byte)-96);
                buffer.writeByte((byte)dataLength);
            }
            value.copyTo(buffer);
        } else {
            buffer.ensureWritable(1);
            buffer.writeByte((byte)64);
        }
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)-16);
        int startIndex = buffer.getWriteOffset();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteOffset();
        long writeSize = endIndex - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
        }
        buffer.setInt(startIndex, (int)writeSize);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)0);
        state.getEncoder().writeUnsignedLong(buffer, state, this.getDescriptorCode());
        buffer.writeByte((byte)-80);
        for (Object value : values) {
            ProtonBuffer binary = ((Data)value).getBuffer();
            buffer.writeInt(binary.getReadableBytes());
            buffer.writeBytes(binary);
        }
    }
}

