/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.transport;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.Encoder;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.Flow;

public final class FlowTypeEncoder
extends AbstractDescribedListTypeEncoder<Flow> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Flow.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Flow.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Flow> getTypeClass() {
        return Flow.class;
    }

    private static void writeCheckedUnsignedInteger(long value, ProtonBuffer buffer) {
        if (value == 0L) {
            buffer.writeByte((byte)67);
        } else if (value <= 255L) {
            buffer.writeByte((byte)82);
            buffer.writeByte((byte)value);
        } else {
            buffer.writeByte((byte)112);
            buffer.writeInt((int)value);
        }
    }

    @Override
    public void writeElement(Flow flow, int index, ProtonBuffer buffer, Encoder encoder, EncoderState state) {
        block14: {
            block13: {
                if (!flow.hasElement(index)) break block13;
                switch (index) {
                    case 0: {
                        FlowTypeEncoder.writeCheckedUnsignedInteger(flow.getNextIncomingId(), buffer);
                        break block14;
                    }
                    case 1: {
                        FlowTypeEncoder.writeCheckedUnsignedInteger(flow.getIncomingWindow(), buffer);
                        break block14;
                    }
                    case 2: {
                        FlowTypeEncoder.writeCheckedUnsignedInteger(flow.getNextOutgoingId(), buffer);
                        break block14;
                    }
                    case 3: {
                        FlowTypeEncoder.writeCheckedUnsignedInteger(flow.getOutgoingWindow(), buffer);
                        break block14;
                    }
                    case 4: {
                        FlowTypeEncoder.writeCheckedUnsignedInteger(flow.getHandle(), buffer);
                        break block14;
                    }
                    case 5: {
                        FlowTypeEncoder.writeCheckedUnsignedInteger(flow.getDeliveryCount(), buffer);
                        break block14;
                    }
                    case 6: {
                        FlowTypeEncoder.writeCheckedUnsignedInteger(flow.getLinkCredit(), buffer);
                        break block14;
                    }
                    case 7: {
                        FlowTypeEncoder.writeCheckedUnsignedInteger(flow.getAvailable(), buffer);
                        break block14;
                    }
                    case 8: {
                        buffer.writeByte(flow.getDrain() ? (byte)65 : 66);
                        break block14;
                    }
                    case 9: {
                        buffer.writeByte(flow.getEcho() ? (byte)65 : 66);
                        break block14;
                    }
                    case 10: {
                        encoder.writeMap(buffer, state, flow.getProperties());
                        break block14;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown Flow value index: " + index);
                    }
                }
            }
            buffer.writeByte((byte)64);
        }
    }

    @Override
    public byte getListEncoding(Flow value) {
        if (value.getProperties() == null) {
            return -64;
        }
        return -48;
    }

    @Override
    public int getElementCount(Flow flow) {
        return flow.getElementCount();
    }

    @Override
    public int getMinElementCount() {
        return 4;
    }
}

