/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.protonj2.client.impl.ClientConstants;
import org.apache.qpid.protonj2.engine.Connection;
import org.apache.qpid.protonj2.types.Symbol;

public final class ClientConnectionCapabilities {
    private boolean anonymousRelaySupported;
    private boolean delayedDeliverySupported;

    public boolean anonymousRelaySupported() {
        return this.anonymousRelaySupported;
    }

    public boolean deliveryDelaySupported() {
        return this.delayedDeliverySupported;
    }

    ClientConnectionCapabilities determineCapabilities(Connection connection) {
        Symbol[] desired = connection.getDesiredCapabilities();
        Symbol[] offered = connection.getRemoteOfferedCapabilities();
        List<Symbol> offeredSymbols = offered != null ? Arrays.asList(offered) : Collections.EMPTY_LIST;
        List<Symbol> desiredSymbols = desired != null ? Arrays.asList(desired) : Collections.EMPTY_LIST;
        this.anonymousRelaySupported = this.checkAnonymousRelaySupported(desiredSymbols, offeredSymbols);
        this.delayedDeliverySupported = this.checkDeliveryRelaySupported(desiredSymbols, offeredSymbols);
        return this;
    }

    private boolean checkAnonymousRelaySupported(List<Symbol> desired, List<Symbol> offered) {
        return offered.contains(ClientConstants.ANONYMOUS_RELAY);
    }

    private boolean checkDeliveryRelaySupported(List<Symbol> desired, List<Symbol> offered) {
        return offered.contains(ClientConstants.DELAYED_DELIVERY);
    }
}

