/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.messaging;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedMapTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonScanningContext;
import org.apache.qpid.protonj2.codec.decoders.ScanningContext;
import org.apache.qpid.protonj2.codec.decoders.StreamScanningContext;
import org.apache.qpid.protonj2.codec.decoders.primitives.MapTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.MessageAnnotations;

public final class MessageAnnotationsTypeDecoder
extends AbstractDescribedMapTypeDecoder<MessageAnnotations> {
    @Override
    public Class<MessageAnnotations> getTypeClass() {
        return MessageAnnotations.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return MessageAnnotations.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return MessageAnnotations.DESCRIPTOR_SYMBOL;
    }

    @Override
    public MessageAnnotations readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        if (decoder.isNull()) {
            return new MessageAnnotations(null);
        }
        return new MessageAnnotations(this.readMap(buffer, state, (MapTypeDecoder)MessageAnnotationsTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
    }

    public MessageAnnotations[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        MessageAnnotations[] result = new MessageAnnotations[count];
        if (decoder.isNull()) {
            for (int i = 0; i < count; ++i) {
                result[i] = new MessageAnnotations(null);
            }
            return result;
        }
        MapTypeDecoder mapDecoder = (MapTypeDecoder)MessageAnnotationsTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder);
        for (int i = 0; i < count; ++i) {
            result[i] = new MessageAnnotations(this.readMap(buffer, state, mapDecoder));
        }
        return result;
    }

    private Map<Symbol, Object> readMap(ProtonBuffer buffer, DecoderState state, MapTypeDecoder mapDecoder) throws DecodeException {
        int size = mapDecoder.readSize(buffer, state);
        int count = mapDecoder.readCount(buffer, state);
        if (count > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Map encoded size %d is specified to be greater than the amount of data available (%d)", size, buffer.getReadableBytes()));
        }
        LinkedHashMap<Symbol, Object> map = new LinkedHashMap<Symbol, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            Symbol key = state.getDecoder().readSymbol(buffer, state);
            Object value = state.getDecoder().readObject(buffer, state);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public MessageAnnotations readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        if (decoder.isNull()) {
            return new MessageAnnotations(null);
        }
        return new MessageAnnotations(this.readMap(stream, state, (MapTypeDecoder)MessageAnnotationsTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
    }

    public MessageAnnotations[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        MessageAnnotations[] result = new MessageAnnotations[count];
        if (decoder.isNull()) {
            for (int i = 0; i < count; ++i) {
                result[i] = new MessageAnnotations(null);
            }
            return result;
        }
        MapTypeDecoder mapDecoder = (MapTypeDecoder)MessageAnnotationsTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder);
        for (int i = 0; i < count; ++i) {
            result[i] = new MessageAnnotations(this.readMap(stream, state, mapDecoder));
        }
        return result;
    }

    private Map<Symbol, Object> readMap(InputStream stream, StreamDecoderState state, MapTypeDecoder mapDecoder) throws DecodeException {
        int size = mapDecoder.readSize(stream, state);
        int count = mapDecoder.readCount(stream, state);
        LinkedHashMap<Symbol, Object> map = new LinkedHashMap<Symbol, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            Symbol key = state.getDecoder().readSymbol(stream, state);
            Object value = state.getDecoder().readObject(stream, state);
            map.put(key, value);
        }
        return map;
    }

    public static ScanningContext<Symbol> createScanContext(Symbol ... keys) {
        return ProtonScanningContext.createSymbolScanContext(keys);
    }

    public static ScanningContext<Symbol> createScanContext(Collection<Symbol> keys) {
        return ProtonScanningContext.createSymbolScanContext(keys);
    }

    public static StreamScanningContext<Symbol> createStreamScanContext(Symbol ... keys) {
        return ProtonScanningContext.createSymbolScanContext(keys);
    }

    public static StreamScanningContext<Symbol> createStreamScanContext(Collection<Symbol> keys) {
        return ProtonScanningContext.createSymbolScanContext(keys);
    }

    public void scanAnnotations(ProtonBuffer buffer, DecoderState state, ScanningContext<Symbol> context, BiConsumer<Symbol, Object> matchConsumer) throws DecodeException {
        this.scanMapEntries(buffer, state, context, matchConsumer);
    }

    public void scanAnnotations(InputStream stream, StreamDecoderState state, StreamScanningContext<Symbol> context, BiConsumer<Symbol, Object> matchConsumer) throws DecodeException {
        this.scanMapEntries(stream, state, context, matchConsumer);
    }
}

