/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.engine.EngineHandler;
import org.apache.qpid.protonj2.engine.EngineHandlerContext;
import org.apache.qpid.protonj2.engine.EnginePipeline;
import org.apache.qpid.protonj2.engine.EngineState;
import org.apache.qpid.protonj2.engine.HeaderEnvelope;
import org.apache.qpid.protonj2.engine.IncomingAMQPEnvelope;
import org.apache.qpid.protonj2.engine.OutgoingAMQPEnvelope;
import org.apache.qpid.protonj2.engine.SASLEnvelope;
import org.apache.qpid.protonj2.engine.exceptions.EngineFailedException;
import org.apache.qpid.protonj2.engine.exceptions.ProtonException;
import org.apache.qpid.protonj2.engine.impl.ProtonEngine;
import org.apache.qpid.protonj2.engine.impl.ProtonEngineHandlerContext;

public class ProtonEnginePipeline
implements EnginePipeline {
    EngineHandlerContextReadBoundary head;
    EngineHandlerContextWriteBoundary tail;
    private final ProtonEngine engine;

    ProtonEnginePipeline(ProtonEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Parent transport cannot be null");
        }
        this.engine = engine;
        this.head = new EngineHandlerContextReadBoundary();
        this.tail = new EngineHandlerContextWriteBoundary();
        this.head.next = this.tail;
        this.head.previous = this.head;
        this.tail.previous = this.head;
        this.tail.next = this.tail;
    }

    @Override
    public ProtonEngine engine() {
        return this.engine;
    }

    @Override
    public ProtonEnginePipeline addFirst(String name, EngineHandler handler) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Handler name cannot be null or empty");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Handler provided cannot be null");
        }
        ProtonEngineHandlerContext oldFirst = this.head.next;
        ProtonEngineHandlerContext newFirst = this.createContext(name, handler);
        newFirst.next = oldFirst;
        newFirst.previous = this.head;
        oldFirst.previous = newFirst;
        this.head.next = newFirst;
        try {
            newFirst.handler().handlerAdded(newFirst);
        }
        catch (Throwable e) {
            this.engine.engineFailed(e);
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline addLast(String name, EngineHandler handler) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Handler name cannot be null or empty");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Handler provided cannot be null");
        }
        ProtonEngineHandlerContext oldLast = this.tail.previous;
        ProtonEngineHandlerContext newLast = this.createContext(name, handler);
        newLast.next = this.tail;
        newLast.previous = oldLast;
        oldLast.next = newLast;
        this.tail.previous = newLast;
        try {
            newLast.handler().handlerAdded(newLast);
        }
        catch (Throwable e) {
            this.engine.engineFailed(e);
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline removeFirst() {
        if (this.head.next != this.tail) {
            ProtonEngineHandlerContext oldFirst = this.head.next;
            this.head.next = oldFirst.next;
            this.head.next.previous = this.head;
            try {
                oldFirst.handler().handlerRemoved(oldFirst);
            }
            catch (Throwable e) {
                this.engine.engineFailed(e);
            }
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline removeLast() {
        if (this.tail.previous != this.head) {
            ProtonEngineHandlerContext oldLast = this.tail.previous;
            this.tail.previous = oldLast.previous;
            this.tail.previous.next = this.tail;
            try {
                oldLast.handler().handlerRemoved(oldLast);
            }
            catch (Throwable e) {
                this.engine.engineFailed(e);
            }
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline remove(String name) {
        if (name != null && !name.isEmpty()) {
            ProtonEngineHandlerContext current = this.head.next;
            ProtonEngineHandlerContext removed = null;
            while (current != this.tail) {
                if (current.name().equals(name)) {
                    ProtonEngineHandlerContext newNext;
                    removed = current;
                    current.previous.next = newNext = current.next;
                    newNext.previous = current.previous;
                    break;
                }
                current = current.next;
            }
            if (removed != null) {
                try {
                    removed.handler().handlerRemoved(removed);
                }
                catch (Throwable e) {
                    this.engine.engineFailed(e);
                }
            }
        }
        return this;
    }

    @Override
    public EnginePipeline remove(EngineHandler handler) {
        if (handler != null) {
            ProtonEngineHandlerContext current = this.head.next;
            ProtonEngineHandlerContext removed = null;
            while (current != this.tail) {
                if (current.handler() == handler) {
                    ProtonEngineHandlerContext newNext;
                    removed = current;
                    current.previous.next = newNext = current.next;
                    newNext.previous = current.previous;
                    break;
                }
                current = current.next;
            }
            if (removed != null) {
                try {
                    removed.handler().handlerRemoved(removed);
                }
                catch (Throwable e) {
                    this.engine.engineFailed(e);
                }
            }
        }
        return this;
    }

    @Override
    public EngineHandler find(String name) {
        EngineHandler handler = null;
        if (name != null && !name.isEmpty()) {
            ProtonEngineHandlerContext current = this.head.next;
            while (current != this.tail) {
                if (current.name().equals(name)) {
                    handler = current.handler();
                    break;
                }
                current = current.next;
            }
        }
        return handler;
    }

    @Override
    public EngineHandler first() {
        return this.head.next == this.tail ? null : this.head.next.handler();
    }

    @Override
    public EngineHandler last() {
        return this.tail.previous == this.head ? null : this.tail.previous.handler();
    }

    @Override
    public EngineHandlerContext firstContext() {
        return this.head.next == this.tail ? null : this.head.next;
    }

    @Override
    public EngineHandlerContext lastContext() {
        return this.tail.previous == this.head ? null : this.tail.previous;
    }

    @Override
    public ProtonEnginePipeline fireEngineStarting() {
        ProtonEngineHandlerContext current = this.head;
        while (current != this.tail) {
            if (this.engine.state().ordinal() >= EngineState.SHUTTING_DOWN.ordinal()) continue;
            try {
                current.fireEngineStarting();
            }
            catch (Throwable error) {
                this.engine.engineFailed(error);
                break;
            }
            current = current.next;
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline fireEngineStateChanged() {
        try {
            this.head.fireEngineStateChanged();
        }
        catch (Throwable error) {
            this.engine.engineFailed(error);
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline fireFailed(EngineFailedException e) {
        try {
            this.head.fireFailed(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline fireRead(ProtonBuffer input) {
        try {
            this.tail.fireRead(input);
        }
        catch (Throwable error) {
            this.engine.engineFailed(error);
            throw error;
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline fireRead(HeaderEnvelope header) {
        try {
            this.tail.fireRead(header);
        }
        catch (Throwable error) {
            this.engine.engineFailed(error);
            throw error;
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline fireRead(SASLEnvelope envelope) {
        try {
            this.tail.fireRead(envelope);
        }
        catch (Throwable error) {
            this.engine.engineFailed(error);
            throw error;
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline fireRead(IncomingAMQPEnvelope envelope) {
        try {
            this.tail.fireRead(envelope);
        }
        catch (Throwable error) {
            this.engine.engineFailed(error);
            throw error;
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline fireWrite(HeaderEnvelope envelope) {
        try {
            this.head.fireWrite(envelope);
        }
        catch (Throwable error) {
            this.engine.engineFailed(error);
            throw error;
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline fireWrite(OutgoingAMQPEnvelope envelope) {
        try {
            this.head.fireWrite(envelope);
        }
        catch (Throwable error) {
            this.engine.engineFailed(error);
            throw error;
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline fireWrite(SASLEnvelope envelope) {
        try {
            this.head.fireWrite(envelope);
        }
        catch (Throwable error) {
            this.engine.engineFailed(error);
            throw error;
        }
        return this;
    }

    @Override
    public ProtonEnginePipeline fireWrite(ProtonBuffer buffer, Runnable ioComplete) {
        try {
            this.head.fireWrite(buffer, ioComplete);
        }
        catch (Throwable error) {
            this.engine.engineFailed(error);
            throw error;
        }
        return this;
    }

    private ProtonEngineHandlerContext createContext(String name, EngineHandler handler) {
        return new ProtonEngineHandlerContext(name, this.engine, handler);
    }

    private class EngineHandlerContextReadBoundary
    extends ProtonEngineHandlerContext {
        public EngineHandlerContextReadBoundary() {
            super("Read Boundary", ProtonEnginePipeline.this.engine, new BoundaryEngineHandler());
        }

        @Override
        public void fireRead(ProtonBuffer buffer) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed Transport read event."));
        }

        @Override
        public void fireRead(HeaderEnvelope header) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed AMQP Header event."));
        }

        @Override
        public void fireRead(SASLEnvelope envelope) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed SASL performative event."));
        }

        @Override
        public void fireRead(IncomingAMQPEnvelope envelope) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed protocol performative event."));
        }
    }

    private class EngineHandlerContextWriteBoundary
    extends ProtonEngineHandlerContext {
        public EngineHandlerContextWriteBoundary() {
            super("Write Boundary", ProtonEnginePipeline.this.engine, new BoundaryEngineHandler());
        }

        @Override
        public void fireWrite(HeaderEnvelope envelope) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed write AMQP Header event."));
        }

        @Override
        public void fireWrite(OutgoingAMQPEnvelope envelope) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed write AMQP performative event."));
        }

        @Override
        public void fireWrite(SASLEnvelope envelope) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed write SASL performative event."));
        }

        @Override
        public void fireWrite(ProtonBuffer buffer, Runnable ioComplete) {
            try {
                ProtonEnginePipeline.this.engine.dispatchWriteToEventHandler(buffer, ioComplete);
            }
            catch (Throwable error) {
                throw ProtonEnginePipeline.this.engine.engineFailed(error);
            }
        }
    }

    private class BoundaryEngineHandler
    implements EngineHandler {
        private BoundaryEngineHandler() {
        }

        @Override
        public void engineStarting(EngineHandlerContext context) {
        }

        @Override
        public void handleRead(EngineHandlerContext context, ProtonBuffer buffer) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed Transport read event."));
        }

        @Override
        public void handleRead(EngineHandlerContext context, HeaderEnvelope header) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed AMQP Header event."));
        }

        @Override
        public void handleRead(EngineHandlerContext context, SASLEnvelope envelope) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed SASL performative read event."));
        }

        @Override
        public void handleRead(EngineHandlerContext context, IncomingAMQPEnvelope envelope) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed protocol performative read event."));
        }

        @Override
        public void handleWrite(EngineHandlerContext context, HeaderEnvelope envelope) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed write AMQP Header event."));
        }

        @Override
        public void handleWrite(EngineHandlerContext context, OutgoingAMQPEnvelope envelope) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed write AMQP performative event."));
        }

        @Override
        public void handleWrite(EngineHandlerContext context, SASLEnvelope envelope) {
            throw ProtonEnginePipeline.this.engine.engineFailed(new ProtonException("No handler processed write SASL performative event."));
        }
    }
}

