/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ranger.services.hive;

public enum RangerHiveOperationType {
    CREATEDATABASE,
    CREATEFUNCTION,
    CREATETABLE,
    CREATEVIEW,
    CREATE_MATERIALIZED_VIEW,
    CREATETABLE_AS_SELECT,
    CREATE_MAPPING,
    CREATE_RESOURCEPLAN,
    CREATE_TRIGGER,
    CREATE_POOL,
    CREATE_SCHEDULED_QUERY,
    ALTERDATABASE,
    ALTERDATABASE_OWNER,
    ALTERINDEX_PROPS,
    ALTERINDEX_REBUILD,
    ALTERDATABASE_LOCATION,
    ALTERPARTITION_BUCKETNUM,
    ALTERPARTITION_FILEFORMAT,
    ALTERPARTITION_LOCATION,
    ALTERPARTITION_MERGEFILES,
    ALTERPARTITION_PROTECTMODE,
    ALTERPARTITION_SERDEPROPERTIES,
    ALTERPARTITION_SERIALIZER,
    ALTERTABLE_ADDCOLS,
    ALTERTABLE_ADDPARTS,
    ALTERTABLE_ARCHIVE,
    ALTERTABLE_BUCKETNUM,
    ALTERTABLE_CLUSTER_SORT,
    ALTERTABLE_COMPACT,
    ALTERTABLE_DROPPARTS,
    ALTERTABLE_DROPCONSTRAINT,
    ALTERTABLE_ADDCONSTRAINT,
    ALTERTABLE_FILEFORMAT,
    ALTERTABLE_LOCATION,
    ALTERTABLE_MERGEFILES,
    ALTERTABLE_PARTCOLTYPE,
    ALTERTABLE_PROPERTIES,
    ALTERTABLE_PROTECTMODE,
    ALTERTABLE_RENAME,
    ALTERTABLE_RENAMECOL,
    ALTERTABLE_RENAMEPART,
    ALTERTABLE_REPLACECOLS,
    ALTERTABLE_SERDEPROPERTIES,
    ALTERTABLE_SERIALIZER,
    ALTERTABLE_SKEWED,
    ALTERTABLE_TOUCH,
    ALTERTABLE_UNARCHIVE,
    ALTERTABLE_UPDATEPARTSTATS,
    ALTERTABLE_UPDATETABLESTATS,
    ALTERTABLE_UPDATECOLUMNS,
    ALTERTABLE_EXCHANGEPARTITION,
    ALTERTABLE_OWNER,
    ALTERTBLPART_SKEWED_LOCATION,
    ALTERVIEW_AS,
    ALTERVIEW_PROPERTIES,
    ALTERVIEW_RENAME,
    ALTER_RESOURCEPLAN,
    ALTER_MATERIALIZED_VIEW_REWRITE,
    ALTER_MAPPING,
    ALTER_TRIGGER,
    ALTER_POOL,
    ALTER_SCHEDULED_QUERY,
    DROPVIEW_PROPERTIES,
    MSCK,
    DROPFUNCTION,
    DROPINDEX,
    DROPTABLE,
    DROPVIEW,
    DROP_MATERIALIZED_VIEW,
    DROPDATABASE,
    DROP_RESOURCEPLAN,
    DROP_TRIGGER,
    DROP_POOL,
    DROP_MAPPING,
    DROP_SCHEDULED_QUERY,
    CREATEINDEX,
    INDEX,
    IMPORT,
    EXPORT,
    LOAD,
    LOCKDB,
    LOCKTABLE,
    UNLOCKDB,
    UNLOCKTABLE,
    LOCK,
    QUERY,
    CACHE_METADATA,
    ANALYZE_TABLE,
    SHOWCOLUMNS,
    DESCTABLE,
    SHOWDATABASES,
    SWITCHDATABASE,
    DESCDATABASE,
    SHOWTABLES,
    TRUNCATETABLE,
    GRANT_PRIVILEGE,
    REVOKE_PRIVILEGE,
    SHOW_TABLESTATUS,
    SHOW_TBLPROPERTIES,
    SHOW_CREATEDATABASE,
    SHOW_CREATETABLE,
    SHOW_RESOURCEPLAN,
    SHOWMATERIALIZEDVIEWS,
    SHOWVIEWS,
    SHOWINDEXES,
    SHOWPARTITIONS,
    ADD,
    DELETE,
    COMPILE,
    CREATEMACRO,
    CREATEROLE,
    DESCFUNCTION,
    DFS,
    RELOADFUNCTION,
    DROPMACRO,
    DROPROLE,
    EXPLAIN,
    GRANT_ROLE,
    REVOKE_ROLE,
    RESET,
    SET,
    COMMIT,
    ROLLBACK,
    SET_AUTOCOMMIT,
    GET_CATALOGS,
    GET_COLUMNS,
    GET_FUNCTIONS,
    GET_SCHEMAS,
    GET_TABLES,
    GET_TABLETYPES,
    GET_TYPEINFO,
    SHOWCONF,
    SHOWFUNCTIONS,
    SHOWLOCKS,
    SHOW_COMPACTIONS,
    SHOW_GRANT,
    SHOW_ROLES,
    SHOW_ROLE_GRANT,
    SHOW_ROLE_PRINCIPALS,
    SHOW_TRANSACTIONS,
    ABORT_TRANSACTIONS,
    START_TRANSACTION,
    REPLDUMP,
    REPLLOAD,
    REPLSTATUS,
    KILL_QUERY,
    LLAP_CLUSTER_INFO,
    LLAP_CACHE_PURGE;

    private RangerHiveOperationType() {
    }
}

