<!---
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# Performance and Scalability Analyzer for Apache Ranger
## Documentation
Run the below command to generate pydocs for the package. Code base has doc strings describing the methods and classes from which the document is generated.
 
```bash
> python -m pydoc -b
```

Other README files can be found in the following directory:

```/config/README.md```: Describes the primary and secondary config files which the user has to modify

```/outputs/README.md```: Describes the output files generated by the analyzer

## Server side installation
```bash
> sudo apt-get install sysstat
or
> sudo yum install sysstat
```
```ranger.accesslog.pattern``` to include the `%D` in the access pattern so that the tomcat server also logs the api execution time

## Client side Installation

Use the package manager [pip](https://pip.pypa.io/en/stable/) to install requirements for running the performance tests.
Ensure right path to requirements.txt is given.

```bash
> pip install -r requirements.txt

> apt-get install sshpass 
or
> brew install hudochenkov/sshpass/sshpass
```


## Usage
```cd``` into ```python``` directory before executing below commands

First time usage or to reset the config files:
```bash 
> python setup_performance_analyzer.py
```

Subsequent usage:
Fill out the config details (```primary_config.json``` and ```secondary_config.json```) in ```/config``` folder or keep default

For multiple api testing (Uses values from config file).

usage:

```bash
> python3 performance_analyzer.py
```

For single api testing (Command line arguments override config file values)

usage:
    
```bash
> python performance_analyzer.py --ranger_url <ranger_url> --calls <number of times to call api> --api <name of function of python client corresponding to api> --username <Auth username> --password <Auth password> --client_ip <client ip address>  --ssh_host <ranger host to connect for ssh> --ssh_user <Server user e.g. root> --ssh_password <Server password>
```

Example command:

```bash
> python3 performance_analyzer.py --ranger_url http://ranger_host:ranger_admin_port --calls 10 --api create_policy --username admin --password Admin123 --client_ip vpn_ip_client_in_logs --ssh_host ranger_host --ssh_user ssh_user --ssh_password ssh_password
```

## Description of tools used
System metrics on server side are collected using [vmstat](https://phoenixnap.com/kb/vmstat-command)

## Warnings
Ensure sudo/root privileges for the user on the server side for vmstat command.

Ensure VPN is enables and client can communicate with the server. Else, in some cases stale values from previous successful run of the tool may be presented 