/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.elasticsearch.authorizer;

import java.util.List;
import org.apache.ranger.authorization.elasticsearch.authorizer.RangerElasticsearchAccessControl;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerElasticsearchAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(RangerElasticsearchAuthorizer.class);
    private static final String RANGER_PLUGIN_TYPE = "elasticsearch";
    private static final String RANGER_ELASTICSEARCH_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.elasticsearch.authorizer.RangerElasticsearchAuthorizer";
    private RangerPluginClassLoader rangerPluginClassLoader = null;
    private ClassLoader esClassLoader = null;
    private RangerElasticsearchAccessControl rangerElasticsearchAccessControl = null;

    public RangerElasticsearchAuthorizer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerElasticsearchAuthorizer.RangerElasticsearchAuthorizer()");
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerElasticsearchAuthorizer.RangerElasticsearchAuthorizer()");
        }
    }

    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerElasticsearchAuthorizer.init()");
        }
        try {
            this.esClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Thread.currentThread().setContextClassLoader(this.esClassLoader);
            Class<?> cls = Class.forName(RANGER_ELASTICSEARCH_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.rangerElasticsearchAccessControl = (RangerElasticsearchAccessControl)cls.newInstance();
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerElasticsearchAuthorizer", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerElasticsearchAuthorizer.init()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPermission(String user, List<String> groups, String index, String action, String clientIPAddress) {
        boolean ret = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerElasticsearchAuthorizer.checkPermission()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.rangerElasticsearchAccessControl.checkPermission(user, groups, index, action, clientIPAddress);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerElasticsearchAuthorizer.checkPermission()");
        }
        return ret;
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.rangerPluginClassLoader);
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.esClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.esClassLoader);
        }
    }
}

