/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.MultivariateNormalDistribution;
import org.apache.commons.math3.distribution.MultivariateRealDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.MarkovChainEvaluator;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class SampleEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    private static final long serialVersionUID = 1L;

    public SampleEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... objects) throws IOException {
        if (objects.length < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        Object first = objects[0];
        if (!(first instanceof MultivariateRealDistribution || first instanceof RealDistribution || first instanceof IntegerDistribution || first instanceof MarkovChainEvaluator.MarkovChain)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a Markov Chain, Real or Integer Distribution", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
        }
        Object second = null;
        if (objects.length > 1) {
            second = objects[1];
        }
        if (first instanceof MarkovChainEvaluator.MarkovChain) {
            MarkovChainEvaluator.MarkovChain markovChain = (MarkovChainEvaluator.MarkovChain)first;
            if (second != null) {
                return Arrays.stream(markovChain.sample(((Number)second).intValue())).mapToObj(item -> item).collect(Collectors.toList());
            }
            return markovChain.sample();
        }
        if (first instanceof RealDistribution) {
            RealDistribution realDistribution = (RealDistribution)first;
            if (second != null) {
                return Arrays.stream(realDistribution.sample(((Number)second).intValue())).mapToObj(item -> item).collect(Collectors.toList());
            }
            return realDistribution.sample();
        }
        if (first instanceof MultivariateNormalDistribution) {
            if (second != null) {
                MultivariateNormalDistribution multivariateNormalDistribution = (MultivariateNormalDistribution)first;
                int size = ((Number)second).intValue();
                double[][] samples = new double[size][];
                for (int i = 0; i < size; ++i) {
                    samples[i] = multivariateNormalDistribution.sample();
                }
                return new Matrix(samples);
            }
            MultivariateNormalDistribution multivariateNormalDistribution = (MultivariateNormalDistribution)first;
            double[] sample = multivariateNormalDistribution.sample();
            ArrayList<Double> sampleList = new ArrayList<Double>(sample.length);
            for (int i = 0; i < sample.length; ++i) {
                sampleList.add(sample[i]);
            }
            return sampleList;
        }
        IntegerDistribution integerDistribution = (IntegerDistribution)first;
        if (second != null) {
            return Arrays.stream(integerDistribution.sample(((Number)second).intValue())).mapToObj(item -> item).collect(Collectors.toList());
        }
        return integerDistribution.sample();
    }
}

