/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class DescribeEvaluator
extends RecursiveNumericEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public DescribeEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (!(value instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a numeric list but found %s", this.toExpression(this.constructingFactory), value.getClass().getSimpleName()));
        }
        DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
        ((List)value).stream().mapToDouble(innerValue -> ((Number)innerValue).doubleValue()).forEach(innerValue -> descriptiveStatistics.addValue(innerValue));
        Tuple tuple = new Tuple();
        tuple.put("max", descriptiveStatistics.getMax());
        tuple.put("mean", descriptiveStatistics.getMean());
        tuple.put("min", descriptiveStatistics.getMin());
        tuple.put("stdev", descriptiveStatistics.getStandardDeviation());
        tuple.put("sum", descriptiveStatistics.getSum());
        tuple.put("N", descriptiveStatistics.getN());
        tuple.put("var", descriptiveStatistics.getVariance());
        tuple.put("kurtosis", descriptiveStatistics.getKurtosis());
        tuple.put("skewness", descriptiveStatistics.getSkewness());
        tuple.put("popVar", descriptiveStatistics.getPopulationVariance());
        tuple.put("geometricMean", descriptiveStatistics.getGeometricMean());
        tuple.put("sumsq", descriptiveStatistics.getSumsq());
        return tuple;
    }
}

