/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import io.airlift.log.Level;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

class StaticFormatter
extends Formatter {
    private static final ZoneId SYSTEM_ZONE = ZoneId.systemDefault().normalized();
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3).appendOffset("+HHMM", "Z").toFormatter(Locale.US);

    StaticFormatter() {
    }

    @Override
    public String formatMessage(LogRecord record) {
        return this.format(record);
    }

    @Override
    public String format(LogRecord record) {
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(record.getMillis()), SYSTEM_ZONE);
        StringWriter stringWriter = new StringWriter().append(TIMESTAMP_FORMATTER.format(timestamp)).append('\t').append(Level.fromJulLevel(record.getLevel()).name()).append('\t').append(Thread.currentThread().getName()).append('\t').append(record.getLoggerName()).append('\t').append(record.getMessage());
        if (record.getThrown() != null) {
            stringWriter.append('\n');
            record.getThrown().printStackTrace(new PrintWriter(stringWriter));
            stringWriter.append('\n');
        }
        stringWriter.append('\n');
        return stringWriter.toString();
    }
}

