/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.RangerKMSDB;
import org.apache.hadoop.crypto.key.RangerKeyStore;
import org.apache.hadoop.crypto.key.RangerKeyStoreProvider;
import org.apache.hadoop.crypto.key.RangerMasterKey;
import org.apache.ranger.kms.dao.DaoManager;

public class VerifyIsDBMasterkeyCorrect {
    RangerMasterKey rangerMasterKey;
    RangerKeyStore dbStore;
    DaoManager daoManager;

    public VerifyIsDBMasterkeyCorrect() throws Throwable {
        Configuration conf = RangerKeyStoreProvider.getDBKSConf();
        RangerKMSDB rangerKMSDB = new RangerKMSDB(conf);
        this.daoManager = rangerKMSDB.getDaoManager();
        this.dbStore = new RangerKeyStore(this.daoManager);
    }

    public static void main(String[] args) throws Throwable {
        if (args.length == 0) {
            System.err.println("Invalid number of parameters found.");
            System.exit(1);
        }
        try {
            String password = args[0];
            if (password == null || password.trim().isEmpty()) {
                System.err.println("KMS Masterkey Password not provided.");
                System.exit(1);
            }
            new VerifyIsDBMasterkeyCorrect().verifyMasterkey(password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void verifyMasterkey(String pass) {
        try {
            this.rangerMasterKey = new RangerMasterKey(this.daoManager);
            String masterKey = this.rangerMasterKey.getMasterKey(pass);
            if (masterKey == null) {
                throw new IOException("Ranger MasterKey does not exists");
            }
            this.dbStore.engineLoad(null, masterKey.toCharArray());
            System.out.println("KMS keystore engine loaded successfully.");
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to load keystore engine with given password or Masterkey was tampered.", e);
        }
    }
}

