/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.cloud.BeforeReconnect;
import org.apache.solr.common.cloud.ConnectionManager;
import org.apache.solr.common.cloud.DefaultConnectionStrategy;
import org.apache.solr.common.cloud.DefaultZkACLProvider;
import org.apache.solr.common.cloud.DefaultZkCredentialsProvider;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.SolrZooKeeper;
import org.apache.solr.common.cloud.ZkACLProvider;
import org.apache.solr.common.cloud.ZkClientConnectionStrategy;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkCredentialsProvider;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrZkClient
implements Closeable {
    static final String NEWL = System.getProperty("line.separator");
    static final int DEFAULT_CLIENT_CONNECT_TIMEOUT = 30000;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ConnectionManager connManager;
    private volatile SolrZooKeeper keeper;
    private ZkCmdExecutor zkCmdExecutor;
    private final ExecutorService zkCallbackExecutor = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrNamedThreadFactory("zkCallback"));
    private final ExecutorService zkConnManagerCallbackExecutor = ExecutorUtil.newMDCAwareSingleThreadExecutor(new SolrNamedThreadFactory("zkConnectionManagerCallback"));
    private volatile boolean isClosed = false;
    private ZkClientConnectionStrategy zkClientConnectionStrategy;
    private int zkClientTimeout;
    private ZkACLProvider zkACLProvider;
    private String zkServerAddress;
    private ConnectionManager.IsClosed higherLevelIsClosed;
    public static final String ZK_CRED_PROVIDER_CLASS_NAME_VM_PARAM_NAME = "zkCredentialsProvider";
    public static final String ZK_ACL_PROVIDER_CLASS_NAME_VM_PARAM_NAME = "zkACLProvider";

    public int getZkClientTimeout() {
        return this.zkClientTimeout;
    }

    public SolrZkClient() {
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout) {
        this(zkServerAddress, zkClientTimeout, new DefaultConnectionStrategy(), null);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout) {
        this(zkServerAddress, zkClientTimeout, zkClientConnectTimeout, new DefaultConnectionStrategy(), null);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout, OnReconnect onReonnect) {
        this(zkServerAddress, zkClientTimeout, zkClientConnectTimeout, new DefaultConnectionStrategy(), onReonnect);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, ZkClientConnectionStrategy strat, OnReconnect onReconnect) {
        this(zkServerAddress, zkClientTimeout, 30000, strat, onReconnect);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, int clientConnectTimeout, ZkClientConnectionStrategy strat, OnReconnect onReconnect) {
        this(zkServerAddress, zkClientTimeout, clientConnectTimeout, strat, onReconnect, null, null, null);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, int clientConnectTimeout, ZkClientConnectionStrategy strat, OnReconnect onReconnect, BeforeReconnect beforeReconnect) {
        this(zkServerAddress, zkClientTimeout, clientConnectTimeout, strat, onReconnect, beforeReconnect, null, null);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, int clientConnectTimeout, ZkClientConnectionStrategy strat, OnReconnect onReconnect, BeforeReconnect beforeReconnect, ZkACLProvider zkACLProvider, ConnectionManager.IsClosed higherLevelIsClosed) {
        this(zkServerAddress, zkClientTimeout, clientConnectTimeout, strat, onReconnect, beforeReconnect, zkACLProvider, higherLevelIsClosed, true);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, int clientConnectTimeout, ZkClientConnectionStrategy strat, OnReconnect onReconnect, BeforeReconnect beforeReconnect, ZkACLProvider zkACLProvider, ConnectionManager.IsClosed higherLevelIsClosed, boolean useDefaultCredsAndACLs) {
        this.zkServerAddress = zkServerAddress;
        this.higherLevelIsClosed = higherLevelIsClosed;
        if (strat == null) {
            strat = new DefaultConnectionStrategy();
        }
        this.zkClientConnectionStrategy = strat;
        if (!strat.hasZkCredentialsToAddAutomatically()) {
            ZkCredentialsProvider zkCredentialsToAddAutomatically = useDefaultCredsAndACLs ? this.createZkCredentialsToAddAutomatically() : new DefaultZkCredentialsProvider();
            strat.setZkCredentialsToAddAutomatically(zkCredentialsToAddAutomatically);
        }
        this.zkClientTimeout = zkClientTimeout;
        this.zkCmdExecutor = new ZkCmdExecutor(zkClientTimeout, new ConnectionManager.IsClosed(){

            @Override
            public boolean isClosed() {
                return SolrZkClient.this.isClosed();
            }
        });
        this.connManager = new ConnectionManager("ZooKeeperConnection Watcher:" + zkServerAddress, this, zkServerAddress, strat, onReconnect, beforeReconnect, new ConnectionManager.IsClosed(){

            @Override
            public boolean isClosed() {
                return SolrZkClient.this.isClosed();
            }
        });
        try {
            strat.connect(zkServerAddress, zkClientTimeout, this.wrapWatcher(this.connManager), zooKeeper -> {
                SolrZooKeeper oldKeeper = this.keeper;
                this.keeper = zooKeeper;
                try {
                    this.closeKeeper(oldKeeper);
                }
                finally {
                    if (this.isClosed) {
                        this.closeKeeper(this.keeper);
                    }
                }
            });
        }
        catch (Exception e) {
            this.connManager.close();
            if (this.keeper != null) {
                try {
                    this.keeper.close();
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        try {
            this.connManager.waitForConnected(clientConnectTimeout);
        }
        catch (Exception e) {
            this.connManager.close();
            try {
                this.keeper.close();
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
            this.zkConnManagerCallbackExecutor.shutdown();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        assert (ObjectReleaseTracker.track(this));
        this.zkACLProvider = zkACLProvider == null ? (useDefaultCredsAndACLs ? this.createZkACLProvider() : new DefaultZkACLProvider()) : zkACLProvider;
    }

    public ConnectionManager getConnectionManager() {
        return this.connManager;
    }

    public ZkClientConnectionStrategy getZkClientConnectionStrategy() {
        return this.zkClientConnectionStrategy;
    }

    protected ZkCredentialsProvider createZkCredentialsToAddAutomatically() {
        String zkCredentialsProviderClassName = System.getProperty(ZK_CRED_PROVIDER_CLASS_NAME_VM_PARAM_NAME);
        if (!StringUtils.isEmpty(zkCredentialsProviderClassName)) {
            try {
                log.info("Using ZkCredentialsProvider: {}", (Object)zkCredentialsProviderClassName);
                return (ZkCredentialsProvider)Class.forName(zkCredentialsProviderClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                log.warn("VM param zkCredentialsProvider does not point to a class implementing ZkCredentialsProvider and with a non-arg constructor", t);
            }
        }
        log.debug("Using default ZkCredentialsProvider");
        return new DefaultZkCredentialsProvider();
    }

    protected ZkACLProvider createZkACLProvider() {
        String zkACLProviderClassName = System.getProperty(ZK_ACL_PROVIDER_CLASS_NAME_VM_PARAM_NAME);
        if (!StringUtils.isEmpty(zkACLProviderClassName)) {
            try {
                log.info("Using ZkACLProvider: {}", (Object)zkACLProviderClassName);
                return (ZkACLProvider)Class.forName(zkACLProviderClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                log.warn("VM param zkACLProvider does not point to a class implementing ZkACLProvider and with a non-arg constructor", t);
            }
        }
        log.debug("Using default ZkACLProvider");
        return new DefaultZkACLProvider();
    }

    public boolean isConnected() {
        return this.keeper != null && this.keeper.getState() == ZooKeeper.States.CONNECTED;
    }

    public void delete(String path, int version, boolean retryOnConnLoss) throws InterruptedException, KeeperException {
        if (retryOnConnLoss) {
            this.zkCmdExecutor.retryOperation(() -> {
                this.keeper.delete(path, version);
                return null;
            });
        } else {
            this.keeper.delete(path, version);
        }
    }

    public Watcher wrapWatcher(Watcher watcher) {
        if (watcher == null || watcher instanceof ProcessWatchWithExecutor) {
            return watcher;
        }
        return new ProcessWatchWithExecutor(watcher);
    }

    public Stat exists(String path, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.exists(path, this.wrapWatcher(watcher)));
        }
        return this.keeper.exists(path, this.wrapWatcher(watcher));
    }

    public Boolean exists(String path, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.exists(path, null) != null);
        }
        return this.keeper.exists(path, null) != null;
    }

    public List<String> getChildren(String path, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.getChildren(path, this.wrapWatcher(watcher)));
        }
        return this.keeper.getChildren(path, this.wrapWatcher(watcher));
    }

    public List<String> getChildren(String path, Watcher watcher, Stat stat, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.getChildren(path, this.wrapWatcher(watcher), stat));
        }
        return this.keeper.getChildren(path, this.wrapWatcher(watcher), stat);
    }

    public byte[] getData(String path, Watcher watcher, Stat stat, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.getData(path, this.wrapWatcher(watcher), stat));
        }
        return this.keeper.getData(path, this.wrapWatcher(watcher), stat);
    }

    public Stat setData(String path, byte[] data, int version, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.setData(path, data, version));
        }
        return this.keeper.setData(path, data, version);
    }

    public void atomicUpdate(String path, Function<byte[], byte[]> editor) throws KeeperException, InterruptedException {
        this.atomicUpdate(path, (Stat stat, byte[] bytes) -> (byte[])editor.apply((byte[])bytes));
    }

    public void atomicUpdate(String path, BiFunction<Stat, byte[], byte[]> editor) throws KeeperException, InterruptedException {
        while (true) {
            byte[] modified = null;
            byte[] zkData = null;
            Stat s = new Stat();
            try {
                if (this.exists(path, true).booleanValue()) {
                    zkData = this.getData(path, null, s, true);
                    modified = editor.apply(s, zkData);
                    if (modified == null) {
                        return;
                    }
                    this.setData(path, modified, s.getVersion(), true);
                    break;
                }
                modified = editor.apply(s, null);
                if (modified == null) {
                    return;
                }
                this.create(path, modified, CreateMode.PERSISTENT, true);
            }
            catch (KeeperException.BadVersionException | KeeperException.NodeExistsException e) {
                continue;
            }
            break;
        }
    }

    public String create(String path, byte[] data, CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.create(path, data, this.zkACLProvider.getACLsToAdd(path), createMode));
        }
        List<ACL> acls = this.zkACLProvider.getACLsToAdd(path);
        return this.keeper.create(path, data, acls, createMode);
    }

    public void makePath(String path, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, null, CreateMode.PERSISTENT, retryOnConnLoss);
    }

    public void makePath(String path, boolean failOnExists, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, null, CreateMode.PERSISTENT, null, failOnExists, retryOnConnLoss, 0);
    }

    public void makePath(String path, File file, boolean failOnExists, boolean retryOnConnLoss) throws IOException, KeeperException, InterruptedException {
        this.makePath(path, FileUtils.readFileToByteArray((File)file), CreateMode.PERSISTENT, null, failOnExists, retryOnConnLoss, 0);
    }

    public void makePath(String path, File file, boolean retryOnConnLoss) throws IOException, KeeperException, InterruptedException {
        this.makePath(path, FileUtils.readFileToByteArray((File)file), retryOnConnLoss);
    }

    public void makePath(String path, CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, null, createMode, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, CreateMode.PERSISTENT, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, createMode, null, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, createMode, watcher, true, retryOnConnLoss, 0);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, Watcher watcher, boolean failOnExists, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, createMode, watcher, failOnExists, retryOnConnLoss, 0);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, Watcher watcher, boolean failOnExists, boolean retryOnConnLoss, int skipPathParts) throws KeeperException, InterruptedException {
        log.debug("makePath: {}", (Object)path);
        boolean retry = true;
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        String[] paths = path.split("/");
        StringBuilder sbPath = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            String pathPiece = paths[i];
            sbPath.append("/").append(pathPiece);
            if (i < skipPathParts) continue;
            byte[] bytes = null;
            String currentPath = sbPath.toString();
            CreateMode mode = CreateMode.PERSISTENT;
            if (i == paths.length - 1) {
                mode = createMode;
                bytes = data;
                if (!retryOnConnLoss) {
                    retry = false;
                }
            }
            try {
                if (retry) {
                    CreateMode finalMode = mode;
                    byte[] finalBytes = bytes;
                    this.zkCmdExecutor.retryOperation(() -> {
                        this.keeper.create(currentPath, finalBytes, this.zkACLProvider.getACLsToAdd(currentPath), finalMode);
                        return null;
                    });
                    continue;
                }
                this.keeper.create(currentPath, bytes, this.zkACLProvider.getACLsToAdd(currentPath), mode);
                continue;
            }
            catch (KeeperException.NoAuthException e) {
                if (i != paths.length - 1 && this.exists(currentPath, retryOnConnLoss).booleanValue()) continue;
                throw e;
            }
            catch (KeeperException.NodeExistsException e) {
                if (!failOnExists && i == paths.length - 1) {
                    this.setData(currentPath, data, -1, retryOnConnLoss);
                    this.exists(currentPath, watcher, retryOnConnLoss);
                    return;
                }
                if (i != paths.length - 1) continue;
                throw e;
            }
        }
    }

    public void makePath(String zkPath, CreateMode createMode, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(zkPath, null, createMode, watcher, retryOnConnLoss);
    }

    public Stat setData(String path, byte[] data, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        return this.setData(path, data, -1, retryOnConnLoss);
    }

    public Stat setData(String path, File file, boolean retryOnConnLoss) throws IOException, KeeperException, InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug("Write to ZooKeeper: {} to {}", (Object)file.getAbsolutePath(), (Object)path);
        }
        byte[] data = FileUtils.readFileToByteArray((File)file);
        return this.setData(path, data, retryOnConnLoss);
    }

    public List<OpResult> multi(Iterable<Op> ops, boolean retryOnConnLoss) throws InterruptedException, KeeperException {
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.multi(ops));
        }
        return this.keeper.multi(ops);
    }

    public void printLayout(String path, int indent, StringBuilder string) throws KeeperException, InterruptedException {
        byte[] data = this.getData(path, null, null, true);
        List<String> children = this.getChildren(path, null, true);
        StringBuilder dent = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            dent.append(" ");
        }
        string.append((CharSequence)dent).append(path).append(" (").append(children.size()).append(")").append(NEWL);
        if (data != null) {
            String dataString = new String(data, StandardCharsets.UTF_8);
            if (!path.endsWith(".txt") && !path.endsWith(".xml") || path.endsWith("/clusterstate.json")) {
                string.append((CharSequence)dent).append("DATA:\n").append((CharSequence)dent).append("    ").append(dataString.replaceAll("\n", "\n" + dent + "    ")).append(NEWL);
            } else {
                string.append((CharSequence)dent).append("DATA: ...supressed...").append(NEWL);
            }
        }
        for (String child : children) {
            if (child.equals("quota")) continue;
            try {
                this.printLayout(path + (path.equals("/") ? "" : "/") + child, indent + 1, string);
            }
            catch (KeeperException.NoNodeException noNodeException) {}
        }
    }

    public void printLayoutToStdOut() throws KeeperException, InterruptedException {
        this.printLayoutToStream(System.out);
    }

    public void printLayoutToStream(PrintStream out) throws KeeperException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        this.printLayout("/", 0, sb);
        out.println(sb.toString());
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.closeCallbackExecutor();
        }
        finally {
            this.connManager.close();
            this.closeKeeper(this.keeper);
        }
        assert (ObjectReleaseTracker.release(this));
    }

    public boolean isClosed() {
        return this.isClosed || this.higherLevelIsClosed != null && this.higherLevelIsClosed.isClosed();
    }

    void updateKeeper(SolrZooKeeper keeper) throws InterruptedException {
        SolrZooKeeper oldKeeper = this.keeper;
        this.keeper = keeper;
        if (oldKeeper != null) {
            oldKeeper.close();
        }
        if (this.isClosed) {
            this.keeper.close();
        }
    }

    public SolrZooKeeper getSolrZooKeeper() {
        return this.keeper;
    }

    private void closeKeeper(SolrZooKeeper keeper) {
        if (keeper != null) {
            try {
                keeper.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
    }

    private void closeCallbackExecutor() {
        try {
            ExecutorUtil.shutdownAndAwaitTermination(this.zkCallbackExecutor);
        }
        catch (Exception e) {
            SolrException.log(log, e);
        }
        try {
            ExecutorUtil.shutdownAndAwaitTermination(this.zkConnManagerCallbackExecutor);
        }
        catch (Exception e) {
            SolrException.log(log, e);
        }
    }

    public static boolean containsChroot(String zkHost) {
        return zkHost.contains("/");
    }

    public static Throwable checkInterrupted(Throwable e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return e;
    }

    public String getZkServerAddress() {
        return this.zkServerAddress;
    }

    public String getConfig() {
        try {
            Stat stat = new Stat();
            this.keeper.sync("/zookeeper/config", null, null);
            byte[] data = this.keeper.getConfig(false, stat);
            if (data == null || data.length == 0) {
                return "";
            }
            return new String(data, StandardCharsets.UTF_8);
        }
        catch (KeeperException.NoNodeException nne) {
            log.debug("Zookeeper does not have the /zookeeper/config znode, assuming old ZK version");
            return "";
        }
        catch (InterruptedException | KeeperException ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to get config from zookeeper", ex);
        }
    }

    public ZkACLProvider getZkACLProvider() {
        return this.zkACLProvider;
    }

    public List<ACL> getACL(String path, Stat stat, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.getACL(path, stat));
        }
        return this.keeper.getACL(path, stat);
    }

    public Stat setACL(String path, List<ACL> acls, boolean retryOnConnLoss) throws InterruptedException, KeeperException {
        if (retryOnConnLoss) {
            return this.zkCmdExecutor.retryOperation(() -> this.keeper.setACL(path, acls, -1));
        }
        return this.keeper.setACL(path, acls, -1);
    }

    public void updateACLs(String root) throws KeeperException, InterruptedException {
        ZkMaintenanceUtils.traverseZkTree(this, root, ZkMaintenanceUtils.VISIT_ORDER.VISIT_POST, path -> {
            try {
                this.setACL(path, this.getZkACLProvider().getACLsToAdd(path), true);
                log.debug("Updated ACL on {}", (Object)path);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        });
    }

    public void clean(String path) throws InterruptedException, KeeperException {
        ZkMaintenanceUtils.clean(this, path);
    }

    public void clean(String path, Predicate<String> nodeFilter) throws InterruptedException, KeeperException {
        ZkMaintenanceUtils.clean(this, path, nodeFilter);
    }

    public void upConfig(Path confPath, String confName) throws IOException {
        ZkMaintenanceUtils.upConfig(this, confPath, confName);
    }

    public String listZnode(String path, Boolean recurse) throws KeeperException, InterruptedException, SolrServerException {
        return ZkMaintenanceUtils.listZnode(this, path, recurse);
    }

    public void downConfig(String confName, Path confPath) throws IOException {
        ZkMaintenanceUtils.downConfig(this, confName, confPath);
    }

    public void zkTransfer(String src, Boolean srcIsZk, String dst, Boolean dstIsZk, Boolean recurse) throws SolrServerException, KeeperException, InterruptedException, IOException {
        ZkMaintenanceUtils.zkTransfer(this, src, srcIsZk, dst, dstIsZk, recurse);
    }

    public void moveZnode(String src, String dst) throws SolrServerException, KeeperException, InterruptedException {
        ZkMaintenanceUtils.moveZnode(this, src, dst);
    }

    public void uploadToZK(Path rootPath, String zkPath, Pattern filenameExclusions) throws IOException {
        ZkMaintenanceUtils.uploadToZK(this, rootPath, zkPath, filenameExclusions);
    }

    public void downloadFromZK(String zkPath, Path dir) throws IOException {
        ZkMaintenanceUtils.downloadFromZK(this, zkPath, dir);
    }

    private final class ProcessWatchWithExecutor
    implements Watcher {
        private final Watcher watcher;

        ProcessWatchWithExecutor(Watcher watcher) {
            if (watcher == null) {
                throw new IllegalArgumentException("Watcher must not be null");
            }
            this.watcher = watcher;
        }

        public void process(WatchedEvent event) {
            block4: {
                log.debug("Submitting job to respond to event {}", (Object)event);
                try {
                    if (this.watcher instanceof ConnectionManager) {
                        SolrZkClient.this.zkConnManagerCallbackExecutor.submit(() -> this.watcher.process(event));
                    } else {
                        SolrZkClient.this.zkCallbackExecutor.submit(() -> this.watcher.process(event));
                    }
                }
                catch (RejectedExecutionException e) {
                    if (SolrZkClient.this.isClosed()) break block4;
                    throw e;
                }
            }
        }

        public int hashCode() {
            return this.watcher.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProcessWatchWithExecutor) {
                return this.watcher.equals(((ProcessWatchWithExecutor)obj).watcher);
            }
            return false;
        }
    }
}

