/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kms.client;

import java.util.List;
import java.util.Map;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.kms.client.KMSClient;
import org.apache.ranger.services.kms.client.KMSConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMSResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(KMSResourceMgr.class);
    private static final String KMSKEY = "keyname";

    public static Map<String, Object> validateConfig(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> KMSResourceMgr.validateConfig ServiceName: " + serviceName + "Configs" + configs);
        }
        try {
            ret = KMSClient.testConnection(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error("<== KMSResourceMgr.validateConfig Error: " + e);
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== KMSResourceMgr.validateConfig Result : " + ret);
        }
        return ret;
    }

    public static List<String> getKMSResources(String serviceName, Map<String, String> configs, ResourceLookupContext context) {
        String userInput = context.getUserInput();
        Map resourceMap = context.getResources();
        List<String> resultList = null;
        List kmsKeyList = null;
        String kmsKeyName = null;
        if (resourceMap != null && !resourceMap.isEmpty() && resourceMap.get(KMSKEY) != null) {
            kmsKeyName = userInput;
            kmsKeyList = (List)resourceMap.get(KMSKEY);
        } else {
            kmsKeyName = userInput;
        }
        if (configs == null || configs.isEmpty()) {
            LOG.error("Connection Config is empty");
        } else {
            String url = configs.get("provider");
            String username = configs.get("username");
            String password = configs.get("password");
            String rangerPrincipal = configs.get("rangerprincipal");
            String rangerKeytab = configs.get("rangerkeytab");
            String nameRules = configs.get("namerules");
            String authType = configs.get("authtype");
            resultList = KMSResourceMgr.getKMSResource(url, username, password, rangerPrincipal, rangerKeytab, nameRules, authType, kmsKeyName, kmsKeyList);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getKMSResource(String url, String username, String password, String rangerPrincipal, String rangerKeytab, String nameRules, String authType, String kmsKeyName, List<String> kmsKeyList) {
        List<String> topologyList = null;
        KMSClient KMSClient2 = KMSConnectionMgr.getKMSClient(url, username, password, rangerPrincipal, rangerKeytab, nameRules, authType);
        if (KMSClient2 != null) {
            KMSClient kMSClient = KMSClient2;
            synchronized (kMSClient) {
                topologyList = KMSClient2.getKeyList(kmsKeyName, kmsKeyList);
            }
        }
        return topologyList;
    }
}

