/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MetricsSnapshot;
import org.apache.hadoop.hbase.master.assignment.MergeTableRegionsProcedure;
import org.apache.hadoop.hbase.master.assignment.SplitTableRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.SnapshotRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.SnapshotVerifyProcedure;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.master.snapshot.MasterSnapshotVerifier;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SnapshotProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.SnapshotState> {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotProcedure.class);
    private final MetricsSnapshot metricsSnapshot = new MetricsSnapshot();
    private Configuration conf;
    private SnapshotProtos.SnapshotDescription snapshot;
    private Path rootDir;
    private Path snapshotDir;
    private Path workingDir;
    private FileSystem workingDirFS;
    private FileSystem rootFs;
    private TableName snapshotTable;
    private MonitoredTask status;
    private SnapshotManifest snapshotManifest;
    private TableDescriptor htd;
    private RetryCounter retryCounter;

    public SnapshotProcedure() {
    }

    public SnapshotProcedure(MasterProcedureEnv env, SnapshotProtos.SnapshotDescription snapshot) {
        super(env);
        this.snapshot = snapshot;
    }

    @Override
    public TableName getTableName() {
        return TableName.valueOf((String)this.snapshot.getTable());
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.SNAPSHOT;
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitTableSharedLock((Procedure<?>)this, this.getTableName())) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeTableSharedLock((Procedure<?>)this, this.getTableName());
    }

    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.SnapshotState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        LOG.info("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case SNAPSHOT_PREPARE: {
                    this.prepareSnapshot(env);
                    this.setNextState(MasterProcedureProtos.SnapshotState.SNAPSHOT_PRE_OPERATION);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case SNAPSHOT_PRE_OPERATION: {
                    this.preSnapshot(env);
                    this.setNextState(MasterProcedureProtos.SnapshotState.SNAPSHOT_WRITE_SNAPSHOT_INFO);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case SNAPSHOT_WRITE_SNAPSHOT_INFO: {
                    SnapshotDescriptionUtils.writeSnapshotInfo(this.snapshot, this.workingDir, this.workingDirFS);
                    TableState tableState = env.getMasterServices().getTableStateManager().getTableState(this.snapshotTable);
                    if (tableState.isEnabled()) {
                        this.setNextState(MasterProcedureProtos.SnapshotState.SNAPSHOT_SNAPSHOT_ONLINE_REGIONS);
                    } else if (tableState.isDisabled()) {
                        this.setNextState(MasterProcedureProtos.SnapshotState.SNAPSHOT_SNAPSHOT_CLOSED_REGIONS);
                    }
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case SNAPSHOT_SNAPSHOT_ONLINE_REGIONS: {
                    this.addChildProcedure(this.createRemoteSnapshotProcedures(env));
                    this.setNextState(MasterProcedureProtos.SnapshotState.SNAPSHOT_SNAPSHOT_SPLIT_REGIONS);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case SNAPSHOT_SNAPSHOT_SPLIT_REGIONS: {
                    this.snapshotSplitRegions(env);
                    this.setNextState(MasterProcedureProtos.SnapshotState.SNAPSHOT_SNAPSHOT_MOB_REGION);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case SNAPSHOT_SNAPSHOT_CLOSED_REGIONS: {
                    this.snapshotClosedRegions(env);
                    this.setNextState(MasterProcedureProtos.SnapshotState.SNAPSHOT_SNAPSHOT_MOB_REGION);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case SNAPSHOT_SNAPSHOT_MOB_REGION: {
                    this.snapshotMobRegion(env);
                    this.setNextState(MasterProcedureProtos.SnapshotState.SNAPSHOT_CONSOLIDATE_SNAPSHOT);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case SNAPSHOT_CONSOLIDATE_SNAPSHOT: {
                    this.status.setStatus("Consolidate snapshot: " + this.snapshot.getName());
                    this.snapshotManifest.consolidate();
                    this.setNextState(MasterProcedureProtos.SnapshotState.SNAPSHOT_VERIFIER_SNAPSHOT);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case SNAPSHOT_VERIFIER_SNAPSHOT: {
                    this.status.setStatus("Verifying snapshot: " + this.snapshot.getName());
                    this.verifySnapshot(env);
                    this.setNextState(MasterProcedureProtos.SnapshotState.SNAPSHOT_COMPLETE_SNAPSHOT);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case SNAPSHOT_COMPLETE_SNAPSHOT: {
                    if (this.isSnapshotCorrupted()) {
                        throw new CorruptedSnapshotException(this.snapshot.getName());
                    }
                    this.completeSnapshot(env);
                    this.setNextState(MasterProcedureProtos.SnapshotState.SNAPSHOT_POST_OPERATION);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case SNAPSHOT_POST_OPERATION: {
                    this.postSnapshot(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
            }
            throw new UnsupportedOperationException("unhandled state=" + state);
        }
        catch (ProcedureSuspendedException e) {
            throw e;
        }
        catch (Exception e) {
            this.setFailure("master-snapshot", e);
            LOG.warn("unexpected exception while execute {}. Mark procedure Failed.", (Object)this, (Object)e);
            this.status.abort("Abort Snapshot " + this.snapshot.getName() + " on Table " + this.snapshotTable);
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.SnapshotState state) throws IOException, InterruptedException {
        if (state == MasterProcedureProtos.SnapshotState.SNAPSHOT_PRE_OPERATION) {
            try {
                if (!this.workingDirFS.delete(this.workingDir, true)) {
                    LOG.error("Couldn't delete snapshot working directory {}", (Object)this.workingDir);
                }
            }
            catch (IOException e) {
                LOG.error("Couldn't delete snapshot working directory {}", (Object)this.workingDir, (Object)e);
            }
        }
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.SnapshotState state) {
        return true;
    }

    protected MasterProcedureProtos.SnapshotState getState(int stateId) {
        return MasterProcedureProtos.SnapshotState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.SnapshotState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.SnapshotState getInitialState() {
        return MasterProcedureProtos.SnapshotState.SNAPSHOT_PREPARE;
    }

    private void prepareSnapshot(MasterProcedureEnv env) throws ProcedureSuspendedException, IOException {
        if (this.isAnySplitOrMergeProcedureRunning(env)) {
            if (this.retryCounter == null) {
                this.retryCounter = ProcedureUtil.createRetryCounter((Configuration)env.getMasterConfiguration());
            }
            long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
            LOG.warn("{} waits {} ms for Split/Merge procedure to finish", (Object)this, (Object)backoff);
            this.setTimeout(Math.toIntExact(backoff));
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            this.skipPersistence();
            throw new ProcedureSuspendedException();
        }
        this.prepareSnapshotEnv(env);
    }

    private void prepareSnapshotEnv(MasterProcedureEnv env) throws IOException {
        this.conf = env.getMasterConfiguration();
        this.snapshotTable = TableName.valueOf((String)this.snapshot.getTable());
        this.htd = this.loadTableDescriptorSnapshot(env);
        this.rootFs = env.getMasterFileSystem().getFileSystem();
        this.rootDir = CommonFSUtils.getRootDir((Configuration)this.conf);
        this.snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(this.snapshot, this.rootDir);
        this.workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(this.snapshot, this.rootDir, this.conf);
        this.workingDirFS = this.workingDir.getFileSystem(this.conf);
        this.status = TaskMonitor.get().createStatus("Taking " + this.snapshot.getType() + " snapshot on table: " + this.snapshotTable);
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(this.snapshot.getName());
        this.snapshotManifest = SnapshotManifest.create(this.conf, this.rootFs, this.workingDir, this.snapshot, monitor, this.status);
        this.snapshotManifest.addTableDescriptor(this.htd);
    }

    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront((Procedure)this);
        return false;
    }

    private boolean isAnySplitOrMergeProcedureRunning(MasterProcedureEnv env) {
        return env.getMasterServices().getMasterProcedureExecutor().getProcedures().stream().filter(p -> !p.isFinished()).filter(p -> p instanceof SplitTableRegionProcedure || p instanceof MergeTableRegionsProcedure).anyMatch(p -> ((AbstractStateMachineTableProcedure)p).getTableName().equals((Object)this.getTableName()));
    }

    private TableDescriptor loadTableDescriptorSnapshot(MasterProcedureEnv env) throws IOException {
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.snapshotTable);
        if (htd == null) {
            throw new IOException("TableDescriptor missing for " + this.snapshotTable);
        }
        if (htd.getMaxFileSize() == -1L && this.snapshot.getMaxFileSize() > 0L) {
            return TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setValue("MAX_FILESIZE", Long.toString(this.snapshot.getMaxFileSize())).build();
        }
        return htd;
    }

    private void preSnapshot(MasterProcedureEnv env) throws IOException {
        env.getMasterServices().getSnapshotManager().prepareWorkingDirectory(this.snapshot);
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preSnapshot(ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)this.snapshot), this.htd, this.getUser());
        }
    }

    private void postSnapshot(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost;
        SnapshotManager sm = env.getMasterServices().getSnapshotManager();
        if (sm != null) {
            sm.unregisterSnapshotProcedure(this.snapshot, this.getProcId());
        }
        if ((cpHost = env.getMasterCoprocessorHost()) != null) {
            cpHost.postSnapshot(ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)this.snapshot), this.htd, this.getUser());
        }
    }

    private void verifySnapshot(MasterProcedureEnv env) throws IOException {
        int verifyThreshold = env.getMasterConfiguration().getInt("hbase.snapshot.remote.verify.threshold", 10000);
        List regions = env.getAssignmentManager().getTableRegions(this.snapshotTable, false).stream().filter(r -> RegionReplicaUtil.isDefaultReplica((RegionInfo)r)).collect(Collectors.toList());
        int numRegions = regions.size();
        MasterSnapshotVerifier verifier = new MasterSnapshotVerifier(env.getMasterServices(), this.snapshot, this.workingDirFS);
        if (numRegions >= verifyThreshold) {
            verifier.verifySnapshot(this.workingDir, false);
            this.addChildProcedure((Procedure[])regions.stream().map(r -> new SnapshotVerifyProcedure(this.snapshot, (RegionInfo)r)).toArray(SnapshotVerifyProcedure[]::new));
        } else {
            verifier.verifySnapshot(this.workingDir, true);
        }
    }

    private void completeSnapshot(MasterProcedureEnv env) throws IOException {
        SnapshotDescriptionUtils.completeSnapshot(this.snapshotDir, this.workingDir, env.getMasterFileSystem().getFileSystem(), this.workingDirFS, this.conf);
        this.metricsSnapshot.addSnapshot(this.status.getCompletionTimestamp() - this.status.getStartTime());
        if (env.getMasterCoprocessorHost() != null) {
            env.getMasterCoprocessorHost().postCompletedSnapshotAction(ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)this.snapshot), this.htd);
        }
        this.status.markComplete("Snapshot " + this.snapshot.getName() + "  completed");
    }

    private void snapshotSplitRegions(MasterProcedureEnv env) throws IOException {
        List<RegionInfo> regions = this.getDefaultRegionReplica(env).filter(RegionInfo::isSplit).collect(Collectors.toList());
        this.snapshotSplitOrClosedRegions(env, regions, "SplitRegionsSnapshotPool");
    }

    private void snapshotClosedRegions(MasterProcedureEnv env) throws IOException {
        List<RegionInfo> regions = this.getDefaultRegionReplica(env).collect(Collectors.toList());
        this.snapshotSplitOrClosedRegions(env, regions, "ClosedRegionsSnapshotPool");
    }

    private Stream<RegionInfo> getDefaultRegionReplica(MasterProcedureEnv env) {
        return env.getAssignmentManager().getTableRegions(this.snapshotTable, false).stream().filter(r -> RegionReplicaUtil.isDefaultReplica((RegionInfo)r));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapshotSplitOrClosedRegions(MasterProcedureEnv env, List<RegionInfo> regions, String threadPoolName) throws IOException {
        ThreadPoolExecutor exec = SnapshotManifest.createExecutor(env.getMasterConfiguration(), threadPoolName);
        try {
            ModifyRegionUtils.editRegions(exec, regions, new ModifyRegionUtils.RegionEditTask(){

                @Override
                public void editRegion(RegionInfo region) throws IOException {
                    SnapshotProcedure.this.snapshotManifest.addRegion(CommonFSUtils.getTableDir((Path)SnapshotProcedure.this.rootDir, (TableName)SnapshotProcedure.this.snapshotTable), region);
                    LOG.info("take snapshot region={}, table={}", (Object)region, (Object)SnapshotProcedure.this.snapshotTable);
                }
            });
        }
        finally {
            exec.shutdown();
        }
        this.status.setStatus("Completed referencing closed/split regions of table: " + this.snapshotTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapshotMobRegion(MasterProcedureEnv env) throws IOException {
        if (!MobUtils.hasMobColumns(this.htd)) {
            return;
        }
        ThreadPoolExecutor exec = SnapshotManifest.createExecutor(env.getMasterConfiguration(), "MobRegionSnapshotPool");
        RegionInfo mobRegionInfo = MobUtils.getMobRegionInfo(this.htd.getTableName());
        try {
            ModifyRegionUtils.editRegions(exec, Collections.singleton(mobRegionInfo), new ModifyRegionUtils.RegionEditTask(){

                @Override
                public void editRegion(RegionInfo region) throws IOException {
                    SnapshotProcedure.this.snapshotManifest.addRegion(CommonFSUtils.getTableDir((Path)SnapshotProcedure.this.rootDir, (TableName)SnapshotProcedure.this.snapshotTable), region);
                }
            });
        }
        finally {
            exec.shutdown();
        }
        this.status.setStatus("Completed referencing HFiles for the mob region of table: " + this.snapshotTable);
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.SnapshotProcedureStateData.newBuilder().setSnapshot(this.snapshot).build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.SnapshotProcedureStateData data = (MasterProcedureProtos.SnapshotProcedureStateData)serializer.deserialize(MasterProcedureProtos.SnapshotProcedureStateData.class);
        this.snapshot = data.getSnapshot();
    }

    private Procedure<MasterProcedureEnv>[] createRemoteSnapshotProcedures(MasterProcedureEnv env) {
        return (Procedure[])env.getAssignmentManager().getTableRegions(this.snapshotTable, true).stream().filter(r -> RegionReplicaUtil.isDefaultReplica((RegionInfo)r)).map(r -> new SnapshotRegionProcedure(this.snapshot, (RegionInfo)r)).toArray(SnapshotRegionProcedure[]::new);
    }

    @Override
    public void toStringClassDetails(StringBuilder builder) {
        builder.append(this.getClass().getName()).append(", id=").append(this.getProcId()).append(", snapshot=").append(ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)this.snapshot));
    }

    public SnapshotProtos.SnapshotDescription getSnapshotDesc() {
        return this.snapshot;
    }

    protected void afterReplay(MasterProcedureEnv env) {
        if (this.getCurrentState() == this.getInitialState()) {
            return;
        }
        try {
            this.prepareSnapshotEnv(env);
            boolean snapshotProcedureEnabled = this.conf.getBoolean("hbase.snapshot.procedure.enabled", true);
            if (!snapshotProcedureEnabled) {
                throw new IOException("SnapshotProcedure is DISABLED");
            }
        }
        catch (IOException e) {
            LOG.error("Failed replaying {}, mark procedure as FAILED", (Object)this, (Object)e);
            this.setFailure("master-snapshot", e);
        }
    }

    public SnapshotProtos.SnapshotDescription getSnapshot() {
        return this.snapshot;
    }

    public synchronized void markSnapshotCorrupted() throws IOException {
        Path flagFile = SnapshotDescriptionUtils.getCorruptedFlagFileForSnapshot(this.workingDir);
        if (!this.workingDirFS.exists(flagFile)) {
            this.workingDirFS.create(flagFile).close();
            LOG.info("touch corrupted snapshot flag file {} for {}", (Object)flagFile, (Object)this.snapshot.getName());
        }
    }

    public boolean isSnapshotCorrupted() throws IOException {
        return this.workingDirFS.exists(SnapshotDescriptionUtils.getCorruptedFlagFileForSnapshot(this.workingDir));
    }
}

