/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RpcLogDetails
extends NamedQueuePayload {
    public static final int SLOW_LOG_EVENT = 0;
    private static final Logger LOG = LoggerFactory.getLogger((String)RpcLogDetails.class.getName());
    private final RpcCall rpcCall;
    private Message param;
    private final String clientAddress;
    private final long responseSize;
    private final long blockBytesScanned;
    private final long fsReadTime;
    private final String className;
    private final boolean isSlowLog;
    private final boolean isLargeLog;
    private final Map<String, byte[]> connectionAttributes;
    private final Map<String, byte[]> requestAttributes;

    public RpcLogDetails(RpcCall rpcCall, Message param, String clientAddress, long responseSize, long blockBytesScanned, long fsReadTime, String className, boolean isSlowLog, boolean isLargeLog) {
        super(0);
        this.rpcCall = rpcCall;
        this.clientAddress = clientAddress;
        this.responseSize = responseSize;
        this.blockBytesScanned = blockBytesScanned;
        this.fsReadTime = fsReadTime;
        this.className = className;
        this.isSlowLog = isSlowLog;
        this.isLargeLog = isLargeLog;
        this.connectionAttributes = rpcCall.getConnectionAttributes();
        this.requestAttributes = rpcCall.getRequestAttributes();
        try {
            this.param = param.newBuilderForType().mergeFrom(param.toByteArray()).build();
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Failed to parse protobuf for message {}", (Object)param, (Object)e);
            this.param = param;
        }
    }

    public RpcCall getRpcCall() {
        return this.rpcCall;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public long getResponseSize() {
        return this.responseSize;
    }

    public long getBlockBytesScanned() {
        return this.blockBytesScanned;
    }

    public long getFsReadTime() {
        return this.fsReadTime;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isSlowLog() {
        return this.isSlowLog;
    }

    public boolean isLargeLog() {
        return this.isLargeLog;
    }

    public Message getParam() {
        return this.param;
    }

    public Map<String, byte[]> getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public Map<String, byte[]> getRequestAttributes() {
        return this.requestAttributes;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("rpcCall", (Object)this.rpcCall).append("param", (Object)this.param).append("clientAddress", (Object)this.clientAddress).append("responseSize", this.responseSize).append("className", (Object)this.className).append("isSlowLog", this.isSlowLog).append("isLargeLog", this.isLargeLog).append("connectionAttributes", this.connectionAttributes).append("requestAttributes", this.requestAttributes).toString();
    }
}

