/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.SignalLogger;
import org.apache.hadoop.hdds.utils.VersionInfo;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;
import org.slf4j.Logger;

public final class StringUtils {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final int SHUTDOWN_HOOK_PRIORITY = 0;

    private StringUtils() {
    }

    public static String bytes2String(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, UTF8);
    }

    public static String bytes2String(ByteBuffer bytes) {
        return StringUtils.bytes2String(bytes, UTF8);
    }

    public static String bytes2String(ByteBuffer bytes, Charset charset) {
        return Unpooled.wrappedBuffer((ByteBuffer)bytes.asReadOnlyBuffer()).toString(charset);
    }

    public static String bytes2Hex(ByteBuffer buffer, int max) {
        buffer = buffer.asReadOnlyBuffer();
        int remaining = buffer.remaining();
        int n = Math.min(max, remaining);
        StringBuilder builder = new StringBuilder(3 * n);
        for (int i = 0; i < n; ++i) {
            builder.append(String.format("%02X ", buffer.get()));
        }
        return builder + (remaining > max ? "..." : "");
    }

    public static String bytes2Hex(ByteBuffer buffer) {
        return StringUtils.bytes2Hex(buffer, buffer.remaining());
    }

    public static String bytes2Hex(byte[] array) {
        return StringUtils.bytes2Hex(ByteBuffer.wrap(array));
    }

    public static String bytes2String(byte[] bytes) {
        return StringUtils.bytes2String(bytes, 0, bytes.length);
    }

    public static byte[] string2Bytes(String str) {
        return str.getBytes(UTF8);
    }

    public static String toStartupShutdownString(String prefix, String ... msg) {
        StringBuilder b = new StringBuilder(prefix);
        b.append("\n/************************************************************");
        for (String s : msg) {
            b.append("\n").append(prefix).append(s);
        }
        b.append("\n************************************************************/");
        return b.toString();
    }

    public static void startupShutdownMessage(VersionInfo versionInfo, Class<?> clazz, String[] args, Logger log, OzoneConfiguration conf) {
        String hostname = NetUtils.getHostname();
        String className = clazz.getSimpleName();
        if (log.isInfoEnabled()) {
            log.info(StringUtils.createStartupShutdownMessage(versionInfo, className, hostname, args, HddsUtils.processForLogging(conf)));
        }
        if (SystemUtils.IS_OS_UNIX) {
            try {
                SignalLogger.INSTANCE.register(log);
            }
            catch (Throwable t) {
                log.warn("failed to register any UNIX signal loggers: ", t);
            }
        }
        ShutdownHookManager.get().addShutdownHook(() -> log.info(StringUtils.toStartupShutdownString("SHUTDOWN_MSG: ", "Shutting down " + className + " at " + hostname)), 0);
    }

    public static String createStartupShutdownMessage(VersionInfo versionInfo, String className, String hostname, String[] args, Map<String, String> conf) {
        return StringUtils.toStartupShutdownString("STARTUP_MSG: ", "Starting " + className, "  host = " + hostname, "  args = " + (args != null ? Arrays.asList(args) : new ArrayList()), "  version = " + versionInfo.getVersion(), "  classpath = " + System.getProperty("java.class.path"), "  build = " + versionInfo.getUrl() + "/" + versionInfo.getRevision() + " ; compiled by '" + versionInfo.getUser() + "' on " + versionInfo.getDate(), "  java = " + System.getProperty("java.version"), "  conf = " + conf);
    }

    public static String appendIfNotPresent(String str, char c) {
        Preconditions.checkNotNull((Object)str, (Object)"Input string is null");
        return str.isEmpty() || str.charAt(str.length() - 1) != c ? str + c : str;
    }
}

