/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.hadoop.hdds.client.ReplicatedReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public final class RatisReplicationConfig
implements ReplicatedReplicationConfig {
    private final HddsProtos.ReplicationFactor replicationFactor;
    private static final HddsProtos.ReplicationType REPLICATION_TYPE = HddsProtos.ReplicationType.RATIS;
    private static final RatisReplicationConfig RATIS_ONE_CONFIG = new RatisReplicationConfig(HddsProtos.ReplicationFactor.ONE);
    private static final RatisReplicationConfig RATIS_THREE_CONFIG = new RatisReplicationConfig(HddsProtos.ReplicationFactor.THREE);

    public static RatisReplicationConfig getInstance(HddsProtos.ReplicationFactor factor) {
        if (factor == HddsProtos.ReplicationFactor.ONE) {
            return RATIS_ONE_CONFIG;
        }
        if (factor == HddsProtos.ReplicationFactor.THREE) {
            return RATIS_THREE_CONFIG;
        }
        return new RatisReplicationConfig(factor);
    }

    private RatisReplicationConfig(HddsProtos.ReplicationFactor replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public static boolean hasFactor(ReplicationConfig replicationConfig, HddsProtos.ReplicationFactor factor) {
        if (replicationConfig instanceof RatisReplicationConfig) {
            return ((RatisReplicationConfig)replicationConfig).getReplicationFactor().equals((Object)factor);
        }
        return false;
    }

    @Override
    @JsonProperty(value="replicationType")
    public HddsProtos.ReplicationType getReplicationType() {
        return REPLICATION_TYPE;
    }

    @Override
    public int getRequiredNodes() {
        return this.replicationFactor.getNumber();
    }

    @Override
    public HddsProtos.ReplicationFactor getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @JsonIgnore
    public String getReplication() {
        return String.valueOf(this.replicationFactor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RatisReplicationConfig that = (RatisReplicationConfig)o;
        return this.replicationFactor == that.replicationFactor;
    }

    public int hashCode() {
        return Objects.hash(this.replicationFactor);
    }

    public String toString() {
        return REPLICATION_TYPE.name() + "/" + this.replicationFactor;
    }

    @Override
    public String configFormat() {
        return this.toString();
    }
}

