/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.hadoop.hdds.client.ReplicatedReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public final class StandaloneReplicationConfig
implements ReplicatedReplicationConfig {
    private final HddsProtos.ReplicationFactor replicationFactor;
    private static final String REPLICATION_TYPE = "STANDALONE";
    private static final StandaloneReplicationConfig STANDALONE_ONE_CONFIG = new StandaloneReplicationConfig(HddsProtos.ReplicationFactor.ONE);
    private static final StandaloneReplicationConfig STANDALONE_THREE_CONFIG = new StandaloneReplicationConfig(HddsProtos.ReplicationFactor.THREE);

    public static StandaloneReplicationConfig getInstance(HddsProtos.ReplicationFactor factor) {
        if (factor == HddsProtos.ReplicationFactor.ONE) {
            return STANDALONE_ONE_CONFIG;
        }
        if (factor == HddsProtos.ReplicationFactor.THREE) {
            return STANDALONE_THREE_CONFIG;
        }
        return new StandaloneReplicationConfig(factor);
    }

    private StandaloneReplicationConfig(HddsProtos.ReplicationFactor replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    @Override
    public HddsProtos.ReplicationFactor getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    public int getRequiredNodes() {
        return this.replicationFactor.getNumber();
    }

    @Override
    @JsonIgnore
    public String getReplication() {
        return String.valueOf(this.replicationFactor);
    }

    @Override
    public HddsProtos.ReplicationType getReplicationType() {
        return HddsProtos.ReplicationType.STAND_ALONE;
    }

    @JsonProperty(value="replicationType")
    public String replicationType() {
        return REPLICATION_TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandaloneReplicationConfig that = (StandaloneReplicationConfig)o;
        return this.replicationFactor == that.replicationFactor;
    }

    public int hashCode() {
        return Objects.hash(this.replicationFactor);
    }

    public String toString() {
        return "STANDALONE/" + this.replicationFactor;
    }

    @Override
    public String configFormat() {
        return this.toString();
    }
}

