/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import java.time.Instant;
import java.util.OptionalLong;
import java.util.Scanner;
import org.apache.hadoop.hdds.fs.SpaceUsagePersistence;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveSpaceUsageToFile
implements SpaceUsagePersistence {
    private static final Logger LOG = LoggerFactory.getLogger(SaveSpaceUsageToFile.class);
    private final File file;
    private final Duration expiry;

    public SaveSpaceUsageToFile(File file, Duration expiry) {
        this.file = file;
        this.expiry = expiry;
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"file == null");
        Preconditions.checkArgument((expiry != null ? 1 : 0) != 0, (Object)"expiry == null");
        Preconditions.checkArgument((!expiry.isNegative() && !expiry.isZero() ? 1 : 0) != 0, (String)"invalid expiry: %s", (Object)expiry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OptionalLong load() {
        try (Scanner sc = new Scanner(this.file, StandardCharsets.UTF_8.name());){
            if (!sc.hasNextLong()) {
                LOG.info("Cached usage info in {} has no value", (Object)this.file);
                OptionalLong optionalLong = OptionalLong.empty();
                return optionalLong;
            }
            long cachedValue = sc.nextLong();
            if (!sc.hasNextLong()) {
                LOG.info("Cached usage info in {} has no time", (Object)this.file);
                OptionalLong optionalLong = OptionalLong.empty();
                return optionalLong;
            }
            Instant time = Instant.ofEpochMilli(sc.nextLong());
            if (this.isExpired(time)) {
                LOG.info("Cached usage info in {} is expired: {} ", (Object)this.file, (Object)time);
                OptionalLong optionalLong = OptionalLong.empty();
                return optionalLong;
            }
            LOG.info("Cached usage info found in {}: {} at {}", new Object[]{this.file, cachedValue, time});
            OptionalLong optionalLong = OptionalLong.of(cachedValue);
            return optionalLong;
        }
        catch (FileNotFoundException e) {
            LOG.info("Cached usage info file {} not found", (Object)this.file);
            return OptionalLong.empty();
        }
    }

    @Override
    public void save(SpaceUsageSource source) {
        try {
            Files.deleteIfExists(this.file.toPath());
        }
        catch (IOException e) {
            LOG.warn("Failed to delete old usage file {}: {}.", (Object)this.file, (Object)e.getMessage());
        }
        long used = source.getUsedSpace();
        if (used > 0L) {
            Instant now = Instant.now();
            try (FileOutputStream fileOutput = new FileOutputStream(this.file);
                 OutputStreamWriter out = new OutputStreamWriter((OutputStream)fileOutput, StandardCharsets.UTF_8);){
                out.write(used + " " + now.toEpochMilli());
                ((Writer)out).flush();
            }
            catch (IOException e) {
                LOG.warn("Failed to write usage to {}", (Object)this.file, (Object)e);
            }
        }
    }

    private boolean isExpired(Instant time) {
        return time.plus(this.expiry).isBefore(Instant.now());
    }
}

