/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.crl;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class CRLStatus {
    private final long receivedCRLId;
    private final List<Long> pendingCRLIds;

    public CRLStatus(long receivedCRLId, List<Long> pendingCRLIds) {
        this.receivedCRLId = receivedCRLId;
        this.pendingCRLIds = pendingCRLIds;
    }

    public long getReceivedCRLId() {
        return this.receivedCRLId;
    }

    public List<Long> getPendingCRLIds() {
        return this.pendingCRLIds;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CRLStatus)) {
            return false;
        }
        CRLStatus that = (CRLStatus)obj;
        if (this.receivedCRLId != that.getReceivedCRLId()) {
            return false;
        }
        if (this.pendingCRLIds.size() != that.getPendingCRLIds().size()) {
            return false;
        }
        return CollectionUtils.isEqualCollection(this.pendingCRLIds, that.getPendingCRLIds());
    }

    public int hashCode() {
        return new HashCodeBuilder(81, 145).append(this.receivedCRLId).append(this.pendingCRLIds).toHashCode();
    }

    public String toString() {
        return "CRLStatus{, receivedCRLId=" + this.receivedCRLId + ", pendingCRLIds=" + StringUtils.join(this.pendingCRLIds, (String)",") + '}';
    }
}

