/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.ratis.util.function.CheckedFunction;

public class DelegatedCodec<T, DELEGATE>
implements Codec<T> {
    private final Codec<DELEGATE> delegate;
    private final CheckedFunction<DELEGATE, T, IOException> forward;
    private final CheckedFunction<T, DELEGATE, IOException> backward;
    private final CopyType copyType;

    public DelegatedCodec(Codec<DELEGATE> delegate, CheckedFunction<DELEGATE, T, IOException> forward, CheckedFunction<T, DELEGATE, IOException> backward, CopyType copyType) {
        this.delegate = delegate;
        this.forward = forward;
        this.backward = backward;
        this.copyType = copyType;
    }

    public DelegatedCodec(Codec<DELEGATE> delegate, CheckedFunction<DELEGATE, T, IOException> forward, CheckedFunction<T, DELEGATE, IOException> backward) {
        this(delegate, forward, backward, CopyType.DEEP);
    }

    @Override
    public final boolean supportCodecBuffer() {
        return this.delegate.supportCodecBuffer();
    }

    @Override
    public final CodecBuffer toCodecBuffer(@Nonnull T message, CodecBuffer.Allocator allocator) throws IOException {
        return this.delegate.toCodecBuffer(this.backward.apply(message), allocator);
    }

    @Override
    public final T fromCodecBuffer(@Nonnull CodecBuffer buffer) throws IOException {
        return (T)this.forward.apply(this.delegate.fromCodecBuffer(buffer));
    }

    @Override
    public final byte[] toPersistedFormat(T message) throws IOException {
        return this.delegate.toPersistedFormat(this.backward.apply(message));
    }

    @Override
    public final T fromPersistedFormat(byte[] bytes) throws IOException {
        return (T)this.forward.apply(this.delegate.fromPersistedFormat(bytes));
    }

    @Override
    public T copyObject(T message) {
        if (this.copyType == CopyType.SHALLOW) {
            return message;
        }
        if (this.copyType == CopyType.UNSUPPORTED) {
            throw new UnsupportedOperationException();
        }
        if (message instanceof CopyObject) {
            CopyObject casted = (CopyObject)message;
            return casted.copyObject();
        }
        try {
            return (T)this.forward.apply(this.delegate.copyObject(this.backward.apply(message)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to copyObject", e);
        }
    }

    public static enum CopyType {
        DEEP,
        SHALLOW,
        UNSUPPORTED;

    }
}

