/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.WarningCode;
import io.trino.spi.WarningCodeSupplier;
import java.util.Objects;

public final class TrinoWarning {
    private final WarningCode warningCode;
    private final String message;

    @JsonCreator
    public TrinoWarning(@JsonProperty(value="warningCode") WarningCode warningCode, @JsonProperty(value="message") String message) {
        this.warningCode = Objects.requireNonNull(warningCode, "warningCode is null");
        this.message = Objects.requireNonNull(message, "message is null");
    }

    public TrinoWarning(WarningCodeSupplier warningCodeSupplier, String message) {
        this(warningCodeSupplier.toWarningCode(), message);
    }

    @JsonProperty
    public WarningCode getWarningCode() {
        return this.warningCode;
    }

    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrinoWarning that = (TrinoWarning)o;
        return Objects.equals(this.warningCode, that.warningCode) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.warningCode, this.message);
    }

    public String toString() {
        return String.format("%s, %s", this.warningCode, this.message);
    }
}

