/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.statistics;

import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.Estimate;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class TableStatistics {
    private static final TableStatistics EMPTY = TableStatistics.builder().build();
    private final Estimate rowCount;
    private final Map<ColumnHandle, ColumnStatistics> columnStatistics;

    public static TableStatistics empty() {
        return EMPTY;
    }

    public TableStatistics(Estimate rowCount, Map<ColumnHandle, ColumnStatistics> columnStatistics) {
        this.rowCount = Objects.requireNonNull(rowCount, "rowCount cannot be null");
        if (!rowCount.isUnknown() && rowCount.getValue() < 0.0) {
            throw new IllegalArgumentException(String.format("rowCount must be greater than or equal to 0: %s", rowCount.getValue()));
        }
        this.columnStatistics = Collections.unmodifiableMap(Objects.requireNonNull(columnStatistics, "columnStatistics cannot be null"));
    }

    public Estimate getRowCount() {
        return this.rowCount;
    }

    public Map<ColumnHandle, ColumnStatistics> getColumnStatistics() {
        return this.columnStatistics;
    }

    public boolean isEmpty() {
        return this.equals(TableStatistics.empty());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableStatistics that = (TableStatistics)o;
        return Objects.equals(this.rowCount, that.rowCount) && Objects.equals(this.columnStatistics, that.columnStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.rowCount, this.columnStatistics);
    }

    public String toString() {
        return "TableStatistics{rowCount=" + String.valueOf(this.rowCount) + ", columnStatistics=" + String.valueOf(this.columnStatistics) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<ColumnHandle, ColumnStatistics> columnStatisticsMap = new LinkedHashMap<ColumnHandle, ColumnStatistics>();
        private Estimate rowCount = Estimate.unknown();

        public Builder setRowCount(Estimate rowCount) {
            this.rowCount = Objects.requireNonNull(rowCount, "rowCount cannot be null");
            return this;
        }

        public Builder setColumnStatistics(ColumnHandle columnHandle, ColumnStatistics columnStatistics) {
            Objects.requireNonNull(columnHandle, "columnHandle cannot be null");
            Objects.requireNonNull(columnStatistics, "columnStatistics cannot be null");
            this.columnStatisticsMap.put(columnHandle, columnStatistics);
            return this;
        }

        public TableStatistics build() {
            return new TableStatistics(this.rowCount, this.columnStatisticsMap);
        }
    }
}

