/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VariableWidthType;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;

public abstract class AbstractVariableWidthType
extends AbstractType
implements VariableWidthType {
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    protected static final int EXPECTED_BYTES_PER_ENTRY = 32;
    protected static final TypeOperatorDeclaration DEFAULT_READ_OPERATORS = TypeOperatorDeclaration.extractOperatorDeclaration(DefaultReadOperators.class, MethodHandles.lookup(), Slice.class);
    protected static final TypeOperatorDeclaration DEFAULT_COMPARABLE_OPERATORS = TypeOperatorDeclaration.extractOperatorDeclaration(DefaultComparableOperators.class, MethodHandles.lookup(), Slice.class);
    protected static final TypeOperatorDeclaration DEFAULT_ORDERING_OPERATORS = TypeOperatorDeclaration.extractOperatorDeclaration(DefaultOrderingOperators.class, MethodHandles.lookup(), Slice.class);

    protected AbstractVariableWidthType(TypeSignature signature, Class<?> javaType) {
        super(signature, javaType, VariableWidthBlock.class);
    }

    @Override
    public VariableWidthBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        int expectedBytes = (int)Math.min((long)expectedEntries * (long)expectedBytesPerEntry, (long)maxBlockSizeInBytes);
        return new VariableWidthBlockBuilder(blockBuilderStatus, expectedBytesPerEntry == 0 ? expectedEntries : Math.min(expectedEntries, maxBlockSizeInBytes / expectedBytesPerEntry), expectedBytes);
    }

    @Override
    public VariableWidthBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 32);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
            position = block.getUnderlyingValuePosition(position);
            Slice slice = variableWidthBlock.getRawSlice();
            int offset = variableWidthBlock.getRawSliceOffset(position);
            int length = variableWidthBlock.getSliceLength(position);
            ((VariableWidthBlockBuilder)blockBuilder).writeEntry(slice, offset, length);
        }
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return DEFAULT_READ_OPERATORS;
    }

    @Override
    public int getFlatFixedSize() {
        return 16;
    }

    @Override
    public boolean isFlatVariableWidth() {
        return true;
    }

    @Override
    public int getFlatVariableWidthSize(Block block, int position) {
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        int length = variableWidthBlock.getSliceLength(block.getUnderlyingValuePosition(position));
        if (length <= 12) {
            return 0;
        }
        return length;
    }

    @Override
    public int relocateFlatVariableWidthOffsets(byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, int variableSizeOffset) {
        int length = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
        if (length <= 12) {
            return 0;
        }
        if (variableSizeSlice.length < variableSizeOffset + length) {
            throw new IllegalArgumentException("Variable size slice does not have enough space");
        }
        INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset + 8 + 4, variableSizeOffset);
        return length;
    }

    private static class DefaultReadOperators {
        private DefaultReadOperators() {
        }

        @ScalarOperator(value=OperatorType.READ_VALUE)
        private static Slice readFlatToStack(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] variableSizeSlice) {
            int length = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
            if (length <= 12) {
                return Slices.wrappedBuffer((byte[])fixedSizeSlice, (int)(fixedSizeOffset + 4), (int)length);
            }
            int variableSizeOffset = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 4 + 8);
            return Slices.wrappedBuffer((byte[])variableSizeSlice, (int)variableSizeOffset, (int)length);
        }

        @ScalarOperator(value=OperatorType.READ_VALUE)
        private static void readFlatToBlock(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] variableSizeSlice, BlockBuilder blockBuilder) {
            int length = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
            if (length <= 12) {
                ((VariableWidthBlockBuilder)blockBuilder).writeEntry(fixedSizeSlice, fixedSizeOffset + 4, length);
            } else {
                int variableSizeOffset = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 4 + 8);
                ((VariableWidthBlockBuilder)blockBuilder).writeEntry(variableSizeSlice, variableSizeOffset, length);
            }
        }

        @ScalarOperator(value=OperatorType.READ_VALUE)
        private static void writeFlatFromStack(Slice value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, int variableSizeOffset) {
            int length = value.length();
            INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset, length);
            if (length <= 12) {
                value.getBytes(0, fixedSizeSlice, fixedSizeOffset + 4, length);
            } else {
                INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset + 4 + 8, variableSizeOffset);
                value.getBytes(0, variableSizeSlice, variableSizeOffset, length);
            }
        }

        @ScalarOperator(value=OperatorType.READ_VALUE)
        private static void writeFlatFromBlock(@BlockPosition VariableWidthBlock block, @BlockIndex int position, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, int variableSizeOffset) {
            Slice rawSlice = block.getRawSlice();
            int rawSliceOffset = block.getRawSliceOffset(position);
            int length = block.getSliceLength(position);
            INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset, length);
            if (length <= 12) {
                rawSlice.getBytes(rawSliceOffset, fixedSizeSlice, fixedSizeOffset + 4, length);
            } else {
                INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset + 4 + 8, variableSizeOffset);
                rawSlice.getBytes(rawSliceOffset, variableSizeSlice, variableSizeOffset, length);
            }
        }
    }

    private static class DefaultComparableOperators {
        private DefaultComparableOperators() {
        }

        @ScalarOperator(value=OperatorType.EQUAL)
        private static boolean equalOperator(Slice left, Slice right) {
            return left.equals((Object)right);
        }

        @ScalarOperator(value=OperatorType.EQUAL)
        private static boolean equalOperator(@BlockPosition VariableWidthBlock leftBlock, @BlockIndex int leftPosition, @BlockPosition VariableWidthBlock rightBlock, @BlockIndex int rightPosition) {
            Slice leftRawSlice = leftBlock.getRawSlice();
            int leftRawSliceOffset = leftBlock.getRawSliceOffset(leftPosition);
            int leftLength = leftBlock.getSliceLength(leftPosition);
            Slice rightRawSlice = rightBlock.getRawSlice();
            int rightRawSliceOffset = rightBlock.getRawSliceOffset(rightPosition);
            int rightLength = rightBlock.getSliceLength(rightPosition);
            return leftRawSlice.equals(leftRawSliceOffset, leftLength, rightRawSlice, rightRawSliceOffset, rightLength);
        }

        @ScalarOperator(value=OperatorType.EQUAL)
        private static boolean equalOperator(Slice left, @BlockPosition VariableWidthBlock rightBlock, @BlockIndex int rightPosition) {
            return DefaultComparableOperators.equalOperator(rightBlock, rightPosition, left);
        }

        @ScalarOperator(value=OperatorType.EQUAL)
        private static boolean equalOperator(@BlockPosition VariableWidthBlock leftBlock, @BlockIndex int leftPosition, Slice right) {
            Slice leftRawSlice = leftBlock.getRawSlice();
            int leftRawSliceOffset = leftBlock.getRawSliceOffset(leftPosition);
            int leftLength = leftBlock.getSliceLength(leftPosition);
            return leftRawSlice.equals(leftRawSliceOffset, leftLength, right, 0, right.length());
        }

        @ScalarOperator(value=OperatorType.EQUAL)
        private static boolean equalOperator(@FlatFixed byte[] leftFixedSizeSlice, @FlatFixedOffset int leftFixedSizeOffset, @FlatVariableWidth byte[] leftVariableSizeSlice, @FlatFixed byte[] rightFixedSizeSlice, @FlatFixedOffset int rightFixedSizeOffset, @FlatVariableWidth byte[] rightVariableSizeSlice) {
            int rightLength;
            int leftLength = INT_HANDLE.get(leftFixedSizeSlice, leftFixedSizeOffset);
            if (leftLength != (rightLength = INT_HANDLE.get(rightFixedSizeSlice, rightFixedSizeOffset))) {
                return false;
            }
            if (leftLength <= 12) {
                return Arrays.equals(leftFixedSizeSlice, leftFixedSizeOffset + 4, leftFixedSizeOffset + 4 + leftLength, rightFixedSizeSlice, rightFixedSizeOffset + 4, rightFixedSizeOffset + 4 + leftLength);
            }
            int leftVariableSizeOffset = INT_HANDLE.get(leftFixedSizeSlice, leftFixedSizeOffset + 4 + 8);
            int rightVariableSizeOffset = INT_HANDLE.get(rightFixedSizeSlice, rightFixedSizeOffset + 4 + 8);
            return Arrays.equals(leftVariableSizeSlice, leftVariableSizeOffset, leftVariableSizeOffset + leftLength, rightVariableSizeSlice, rightVariableSizeOffset, rightVariableSizeOffset + rightLength);
        }

        @ScalarOperator(value=OperatorType.EQUAL)
        private static boolean equalOperator(@BlockPosition VariableWidthBlock leftBlock, @BlockIndex int leftPosition, @FlatFixed byte[] rightFixedSizeSlice, @FlatFixedOffset int rightFixedSizeOffset, @FlatVariableWidth byte[] rightVariableSizeSlice) {
            return DefaultComparableOperators.equalOperator(rightFixedSizeSlice, rightFixedSizeOffset, rightVariableSizeSlice, leftBlock, leftPosition);
        }

        @ScalarOperator(value=OperatorType.EQUAL)
        private static boolean equalOperator(@FlatFixed byte[] leftFixedSizeSlice, @FlatFixedOffset int leftFixedSizeOffset, @FlatVariableWidth byte[] leftVariableSizeSlice, @BlockPosition VariableWidthBlock rightBlock, @BlockIndex int rightPosition) {
            int leftLength = INT_HANDLE.get(leftFixedSizeSlice, leftFixedSizeOffset);
            Slice rightRawSlice = rightBlock.getRawSlice();
            int rightRawSliceOffset = rightBlock.getRawSliceOffset(rightPosition);
            int rightLength = rightBlock.getSliceLength(rightPosition);
            if (leftLength != rightLength) {
                return false;
            }
            if (leftLength <= 12) {
                return rightRawSlice.equals(rightRawSliceOffset, rightLength, Slices.wrappedBuffer((byte[])leftFixedSizeSlice, (int)(leftFixedSizeOffset + 4), (int)leftLength), 0, leftLength);
            }
            int leftVariableSizeOffset = INT_HANDLE.get(leftFixedSizeSlice, leftFixedSizeOffset + 4 + 8);
            return rightRawSlice.equals(rightRawSliceOffset, rightLength, Slices.wrappedBuffer((byte[])leftVariableSizeSlice, (int)leftVariableSizeOffset, (int)leftLength), 0, leftLength);
        }

        @ScalarOperator(value=OperatorType.XX_HASH_64)
        private static long xxHash64Operator(Slice value) {
            return XxHash64.hash((Slice)value);
        }

        @ScalarOperator(value=OperatorType.XX_HASH_64)
        private static long xxHash64Operator(@BlockPosition VariableWidthBlock block, @BlockIndex int position) {
            return XxHash64.hash((Slice)block.getRawSlice(), (int)block.getRawSliceOffset(position), (int)block.getSliceLength(position));
        }

        @ScalarOperator(value=OperatorType.XX_HASH_64)
        private static long xxHash64Operator(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] variableSizeSlice) {
            int length = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
            if (length <= 12) {
                return XxHash64.hash((Slice)Slices.wrappedBuffer((byte[])fixedSizeSlice, (int)(fixedSizeOffset + 4), (int)length));
            }
            int variableSizeOffset = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 4 + 8);
            return XxHash64.hash((Slice)Slices.wrappedBuffer((byte[])variableSizeSlice, (int)variableSizeOffset, (int)length));
        }
    }

    private static class DefaultOrderingOperators {
        private DefaultOrderingOperators() {
        }

        @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
        private static long comparisonOperator(Slice left, Slice right) {
            return left.compareTo(right);
        }

        @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
        private static long comparisonOperator(@BlockPosition VariableWidthBlock leftBlock, @BlockIndex int leftPosition, @BlockPosition VariableWidthBlock rightBlock, @BlockIndex int rightPosition) {
            Slice leftRawSlice = leftBlock.getRawSlice();
            int leftRawSliceOffset = leftBlock.getRawSliceOffset(leftPosition);
            int leftLength = leftBlock.getSliceLength(leftPosition);
            Slice rightRawSlice = rightBlock.getRawSlice();
            int rightRawSliceOffset = rightBlock.getRawSliceOffset(rightPosition);
            int rightLength = rightBlock.getSliceLength(rightPosition);
            return leftRawSlice.compareTo(leftRawSliceOffset, leftLength, rightRawSlice, rightRawSliceOffset, rightLength);
        }

        @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
        private static long comparisonOperator(@BlockPosition VariableWidthBlock leftBlock, @BlockIndex int leftPosition, Slice right) {
            Slice leftRawSlice = leftBlock.getRawSlice();
            int leftRawSliceOffset = leftBlock.getRawSliceOffset(leftPosition);
            int leftLength = leftBlock.getSliceLength(leftPosition);
            return leftRawSlice.compareTo(leftRawSliceOffset, leftLength, right, 0, right.length());
        }

        @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
        private static long comparisonOperator(Slice left, @BlockPosition VariableWidthBlock rightBlock, @BlockIndex int rightPosition) {
            Slice rightRawSlice = rightBlock.getRawSlice();
            int rightRawSliceOffset = rightBlock.getRawSliceOffset(rightPosition);
            int rightLength = rightBlock.getSliceLength(rightPosition);
            return left.compareTo(0, left.length(), rightRawSlice, rightRawSliceOffset, rightLength);
        }
    }
}

