/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.schema.registry.client.connection.util;

import com.hortonworks.registries.auth.KerberosLogin;
import com.hortonworks.registries.auth.Login;
import com.hortonworks.registries.auth.NOOPLogin;
import com.hortonworks.registries.auth.util.JaasConfiguration;
import com.hortonworks.registries.schemaregistry.client.SchemaRegistryClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    private static final long KERBEROS_SYNCHRONIZATION_TIMEOUT_MS = 180000L;
    private static final String REGISTY_CLIENT_JAAS_SECTION = "RegistryClient";

    public static boolean isHttpsConnection(Map<String, ?> conf) {
        String urls = conf.get(SchemaRegistryClient.Configuration.SCHEMA_REGISTRY_URL.name()).toString();
        return urls.trim().startsWith("https://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLContext createSSLContext(Map<String, ?> sslConfigurations, String sslAlgorithm) throws Exception {
        Object obj;
        boolean serverCertValidation;
        String trustStoreType;
        String trustStorePassword;
        String trustStorePath;
        String keyStoreType;
        String keyStorePassword;
        SSLContext context = SSLContext.getInstance(sslAlgorithm);
        KeyManager[] km = null;
        String keyStorePath = (String)sslConfigurations.get("keyStorePath");
        if (keyStorePath == null || keyStorePath.isEmpty()) {
            keyStorePath = System.getProperty("javax.net.ssl.keyStore");
        }
        if ((keyStorePassword = (String)sslConfigurations.get("keyStorePassword")) == null || keyStorePath.isEmpty()) {
            keyStorePassword = Optional.ofNullable(System.getProperty("javax.net.ssl.keyStorePassword")).orElse("");
        }
        if ((keyStoreType = (String)sslConfigurations.get("keyStoreType")) == null || keyStoreType.isEmpty()) {
            keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
        }
        if ((trustStorePath = (String)sslConfigurations.get("trustStorePath")) == null || trustStorePath.isEmpty()) {
            trustStorePath = System.getProperty("javax.net.ssl.trustStore");
        }
        if ((trustStorePassword = (String)sslConfigurations.get("trustStorePassword")) == null || trustStorePassword.isEmpty()) {
            trustStorePassword = Optional.ofNullable(System.getProperty("javax.net.ssl.trustStorePassword")).orElse("");
        }
        if ((trustStoreType = (String)sslConfigurations.get("trustStoreType")) == null || trustStoreType.isEmpty()) {
            trustStoreType = System.getProperty("javax.net.ssl.trustStoreType");
        }
        boolean bl = serverCertValidation = (obj = sslConfigurations.get("serverCertValidation")) == null || Boolean.parseBoolean(obj.toString());
        if (keyStorePath != null) {
            KeyStore ks = KeyStore.getInstance(keyStoreType != null ? keyStoreType : KeyStore.getDefaultType());
            try (InputStream in = SecurityUtils.getFileInputStream(keyStorePath);){
                ks.load(in, keyStorePassword.toCharArray());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyStorePassword.toCharArray());
            km = kmf.getKeyManagers();
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        TrustManager[] tm = null;
        if (serverCertValidation) {
            if (trustStorePath != null) {
                KeyStore trustStore = KeyStore.getInstance(trustStoreType != null ? trustStoreType : KeyStore.getDefaultType());
                try (InputStream in = SecurityUtils.getFileInputStream(trustStorePath);){
                    trustStore.load(in, trustStorePassword.toCharArray());
                    trustManagerFactory.init(trustStore);
                    tm = trustManagerFactory.getTrustManagers();
                }
            }
        } else {
            X509TrustManager ignoreValidationTM = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            };
            tm = new TrustManager[]{ignoreValidationTM};
        }
        SecureRandom random = new SecureRandom();
        context.init(km, tm, random);
        return context;
    }

    private static InputStream getFileInputStream(String path) throws FileNotFoundException {
        InputStream ret;
        File f = new File(path);
        if (f.exists()) {
            ret = new FileInputStream(f);
        } else {
            ret = SecurityUtils.class.getResourceAsStream(path);
            if (ret == null && !path.startsWith("/")) {
                ret = SecurityUtils.class.getResourceAsStream("/" + path);
            }
            if (ret == null && (ret = ClassLoader.getSystemClassLoader().getResourceAsStream(path)) == null && !path.startsWith("/")) {
                ret = ClassLoader.getSystemResourceAsStream("/" + path);
            }
        }
        return ret;
    }

    static String getJaasConfigForClientPrincipal(Map<String, ?> conf) {
        String keytabFile = (String)conf.get("lookupkeytab");
        String principal = (String)conf.get("lookupprincipal");
        if (keytabFile == null || keytabFile.isEmpty() || principal == null || principal.isEmpty()) {
            return null;
        }
        return "com.sun.security.auth.module.Krb5LoginModule required useTicketCache=false principal=\"" + principal + "\" useKeyTab=true keyTab=\"" + keytabFile + "\";";
    }

    public static Login initializeSecurityContext(Map<String, ?> conf) {
        String saslJaasConfig = SecurityUtils.getJaasConfigForClientPrincipal(conf);
        boolean kerberosOn = SecurityUtils.isKerberosEnabled(conf);
        if (kerberosOn && saslJaasConfig != null) {
            KerberosLogin kerberosLogin = new KerberosLogin(180000L);
            try {
                kerberosLogin.configure(new HashMap(), REGISTY_CLIENT_JAAS_SECTION, (Configuration)new JaasConfiguration(REGISTY_CLIENT_JAAS_SECTION, saslJaasConfig));
                kerberosLogin.login();
                return kerberosLogin;
            }
            catch (LoginException e) {
                LOG.error("Failed to initialize the dynamic JAAS config: " + saslJaasConfig + ". Attempting static JAAS config.");
            }
            catch (Exception e) {
                LOG.error("Failed to parse the dynamic JAAS config. Attempting static JAAS config.", (Throwable)e);
            }
        }
        return new NOOPLogin();
    }

    static boolean isKerberosEnabled(Map<String, ?> conf) {
        String rangerAuthType = (String)conf.get("authtype");
        String pluginAuthType = (String)conf.get("schema-registry.authentication");
        return rangerAuthType != null && pluginAuthType != null && rangerAuthType.equals("kerberos") && pluginAuthType.equalsIgnoreCase("kerberos");
    }
}

