/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public class MetaJoinFieldMapper
extends FieldMapper {
    static final String NAME = "_parent_join";
    static final String CONTENT_TYPE = "parent_join";

    MetaJoinFieldMapper(String name, String joinField) {
        super(name, Defaults.FIELD_TYPE, (MappedFieldType)new MetaJoinFieldType(joinField), FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
    }

    public MetaJoinFieldType fieldType() {
        return (MetaJoinFieldType)super.fieldType();
    }

    protected MetaJoinFieldMapper clone() {
        return (MetaJoinFieldMapper)super.clone();
    }

    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        throw new IllegalStateException("Should never be called");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        Defaults() {
        }

        static {
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.freeze();
        }
    }

    public static class MetaJoinFieldType
    extends StringFieldType {
        private final String joinField;

        private MetaJoinFieldType(String joinField) {
            super(MetaJoinFieldMapper.NAME, false, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
            this.joinField = joinField;
        }

        public String typeName() {
            return MetaJoinFieldMapper.CONTENT_TYPE;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.BYTES);
        }

        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for metadata field [" + this.typeName() + "].");
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        public String getJoinField() {
            return this.joinField;
        }

        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("Exists query not supported for fields of type" + this.typeName());
        }
    }

    static class Builder
    extends FieldMapper.Builder<Builder> {
        final String joinField;

        Builder(String joinField) {
            super(MetaJoinFieldMapper.NAME, Defaults.FIELD_TYPE);
            this.builder = this;
            this.joinField = joinField;
        }

        public MetaJoinFieldMapper build(Mapper.BuilderContext context) {
            return new MetaJoinFieldMapper(this.name, this.joinField);
        }
    }
}

