/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConnectorTableMetadata {
    private final SchemaTableName table;
    private final Optional<String> comment;
    private final List<ColumnMetadata> columns;
    private final Map<String, Object> properties;

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns) {
        this(table, columns, Collections.emptyMap());
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties) {
        this(table, columns, properties, Optional.empty());
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties, Optional<String> comment) {
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(comment, "comment is null");
        this.table = table;
        this.columns = Collections.unmodifiableList(new ArrayList<ColumnMetadata>(columns));
        this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(properties));
        this.comment = comment;
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public List<ColumnMetadata> getColumns() {
        return this.columns;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectorTableMetadata{");
        sb.append("table=").append(this.table);
        sb.append(", columns=").append(this.columns);
        sb.append(", properties=").append(this.properties);
        this.comment.ifPresent(value -> sb.append(", comment='").append((String)value).append("'"));
        sb.append('}');
        return sb.toString();
    }
}

